/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.translators;

import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.jalbum.util.MiniIO;
import net.jalbum.util.Replacer;
import se.datadosen.jalbum.Config;

public class Main {
    static final String GOOGLE_API_KEY = "AIzaSyCO4_rPtisgdJpVKpfKcAM7gID4ZuChdhU";
    static final String GOOGLE_API_URL = "https://www.googleapis.com/language/translate/v2";
    static final int NET_TIMEOUT = 5000;

    public static void main(String[] args) {
        System.setProperty("jalbum.file.encoding", "UTF-8");
        if (args.length == 0) {
            System.out.println("Usage: TranslatorPlugin.jar <texts folder> [iso2Lang]...");
            return;
        }
        Main.translateFolder(new File(args[0]), Arrays.stream(args, 1, args.length).collect(Collectors.toSet()));
    }

    static Set<String> getAvailableLanguages(File folder) {
        HashSet<String> langs = new HashSet<String>();
        for (File langFile : folder.listFiles((dir, name) -> name.matches("texts_.*\\.properties"))) {
            int dotIndex = langFile.getName().indexOf(46);
            String targetLang = langFile.getName().substring("texts_".length(), dotIndex);
            langs.add(targetLang);
        }
        return langs;
    }

    private static void translateFolder(File folder, Set<String> languages) {
        try {
            File englishText = new File(folder, "texts.properties");
            Map<String, Object> allTexts = MiniIO.readMapFile(englishText, true);
            if (languages.isEmpty()) {
                languages.addAll(Main.getAvailableLanguages(folder));
            }
            for (String lang : languages) {
                File langFile = new File(folder, "texts_" + lang + ".properties");
                if (!langFile.exists()) {
                    langFile.createNewFile();
                }
                LinkedHashMap<String, Object> texts = new LinkedHashMap<String, Object>(allTexts);
                Map current = MiniIO.readMapFile(langFile);
                for (Object k : current.keySet()) {
                    texts.remove(k);
                }
                if (texts.size() > 0) {
                    System.out.print("Updating translation for " + langFile + " (" + texts.size() + " new texts)...");
                    for (Map.Entry entry : texts.entrySet()) {
                        entry.setValue(Main.translateText((String)entry.getValue(), lang));
                    }
                    String content = MiniIO.readTextFile(langFile) + Main.createContent(texts, true);
                    MiniIO.writeTextFile(content, langFile, "UTF-8");
                    System.out.println(" Done");
                    continue;
                }
                System.out.println("No new texts for " + langFile);
            }
        }
        catch (JsonException | IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    static String translateText(String sourceText, String targetLang) throws IOException, JsonException {
        String params = "key=AIzaSyCO4_rPtisgdJpVKpfKcAM7gID4ZuChdhU&q=" + MiniIO.urlEncode(sourceText) + "&format=text&source=en&target=" + targetLang;
        HttpURLConnection connection = (HttpURLConnection)new URL(GOOGLE_API_URL).openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Length", "" + params.length());
        connection.setRequestProperty("X-HTTP-Method-Override", "GET");
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        PrintWriter pw = new PrintWriter(connection.getOutputStream());
        pw.write(params);
        pw.close();
        String res = null;
        try (InputStreamReader reader = new InputStreamReader(connection.getInputStream(), "utf-8");){
            res = MiniIO.readAll(reader);
        }
        JsonObject json = (JsonObject)Jsoner.deserialize(res);
        JsonObject data = (JsonObject)json.get("data");
        JsonArray translations = (JsonArray)data.get("translations");
        if (translations.size() > 0) {
            String translated = (String)((JsonObject)translations.get(0)).get("translatedText");
            return translated;
        }
        throw new IOException("Error from Google Translate: " + res);
    }

    static String createContent(Map all, boolean autoTranslate) {
        return (autoTranslate ? "\n# Google Translated " + all.size() + " texts on " + Config.getConfig().getDateFormatter().format(new Date()) + ". Please check!\n" : "\n#" + all.size() + " texts needs translation:\n") + Main.mapToString(all) + "\n#End adding " + all.size() + " texts\n";
    }

    private static String mapToString(Map map) {
        Replacer backslashEncoder = new Replacer();
        backslashEncoder.add("\\", "\\\\");
        backslashEncoder.add("\n", "\\" + System.getProperty("line.separator"));
        StringWriter writer = new StringWriter();
        try (PrintWriter out = new PrintWriter(writer);){
            for (Map.Entry e : map.entrySet()) {
                out.println(e.getKey().toString() + "=" + backslashEncoder.replace(e.getValue().toString()));
            }
        }
        return writer.getBuffer().toString();
    }
}

