/*
 * Decompiled with CFR 0.152.
 */
package split;

import icons.Lazaicon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.jalbum.component.JDraggableList;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.DeferredSVGIcon;
import se.datadosen.component.FileChooser;
import se.datadosen.component.JColorSelector;
import se.datadosen.component.JLabelFor;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.StateMonitor;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.jalbum.event.JAlbumListener;
import se.datadosen.util.IO;
import se.datadosen.util.Item;
import se.datadosen.util.Languages;
import se.datadosen.util.VersionNumber;
import split.GuiBase;

public class Gui
extends GuiBase {
    private long skinReadyAt = Long.MAX_VALUE;
    private final VersionNumber jalbumVersion = new VersionNumber(AlbumBean.getInternalVersion());
    private final SkinProperties skinProps = new SkinProperties(this.skinDirectory);
    private final String skinVersion = this.skinProps.getProperty("version");
    private final String skinAuthor = this.skinProps.getProperty("author");
    private final String supportForum = this.skinProps.getProperty("supportForum");
    private final String helpRoot = "http://jalbum.net/help/en/Skin/Split";
    private final Border emptyBorder = BorderFactory.createEmptyBorder();
    private final String tabStyle = "style='padding:3px 2px;margin:0'";
    private Font mono = new Font("monospaced", 0, 12);
    private final String[] imageFiles = new String[]{"jpg", "jpeg", "png", "gif", "svg"};
    private final FileChooser fc = ChooserFactory.createFileChooser((Window)this.window);
    ControlPanel skinUi = new ControlPanel(){
        private Icon infoIcon = Gui.icon("info");
        private Icon mandatory = Gui.svgIcon("asterisk", new Dimension(16, 16));
        public JTextField themeImageSize = new JTextField("1600x1600");
        private JTextField styleName = new JTextField(Gui.this.getStyleName());
        JTextField majorSkinVersion;
        JComboBox<Item> fontFamily;
        JComboBox<Item> fontWeight;
        JComboBox headlineFontFamily;
        private final JComboBox fontSuggestions;
        JCheckBox shareFacebook;
        JCheckBox shareThreads;
        JCheckBox shareBlueSky;
        JCheckBox shareTwitter;
        JCheckBox shareLinkedIn;
        JCheckBox sharePinterest;
        JCheckBox shareReddit;
        JCheckBox shareEmail;
        JCheckBox shareLink;
        private PropertyChangeListener setupMonitors;
        ControlPanel site;
        ControlPanel sidebar;
        ControlPanel thumbnails;
        ControlPanel lightbox;
        ControlPanel advanced;
        ControlPanel about;
        JTabbedPane tabs;
        {
            this.majorSkinVersion = new JTextField(Gui.this.majorVersion(Gui.this.skinVersion));
            this.fontFamily = new JComboBox<Item>(new Item[]{new Item((Object)"Arial, \"Helvetica Neue\", Helvetica, sans-serif", (Object)"Arial"), new Item((Object)"Baskerville, \"Baskerville Old Face\", \"Hoefler Text\", Garamond, \"Times New Roman\", serif", (Object)"Baskerville"), new Item((Object)"Calibri, Candara, Segoe, \"Segoe UI\", Optima, Arial, sans-serif", (Object)"Calibri"), new Item((Object)"Cambria, Georgia, Times, \"Times New Roman\", serif", (Object)"Cambria"), new Item((Object)"\"Century Gothic\", \"Apple Gothic\", \"Goudy Old Style\", sans-serif", (Object)"Century Gothic"), new Item((Object)"\"Comic Sans MS\", cursive", (Object)"Comic Sans"), new Item((Object)"Consolas, \"Lucida Console\", Monaco, monospace", (Object)"Consolas"), new Item((Object)"Constantia, Palatino, \"Palatino Linotype\", \"Palatino LT STD\", Georgia, serif", (Object)"Constantia"), new Item((Object)"\"Copperplate Light\", \"Copperplate Gothic Light\", serif", (Object)"Copperplate Light"), new Item((Object)"\"Courier New\", Courier, monospace", (Object)"Courier New"), new Item((Object)"\"Franklin Gothic Medium\", \"Arial Narrow Bold\", Arial, sans-serif", (Object)"Franklin Gothic"), new Item((Object)"Futura, \"Century Gothic\", AppleGothic, sans-serif", (Object)"Futura"), new Item((Object)"Garamond, \"Hoefler Text\", Times New Roman, Times, serif", (Object)"Garamond"), new Item((Object)"Geneva, \"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", (Object)"Geneva"), new Item((Object)"Georgia, Palatino, \"Palatino Linotype\", Times, \"Times New Roman\", serif", (Object)"Georgia"), new Item((Object)"\"Gill Sans\", \"Gill Sans MT\", Calibri, \"Trebuchet MS\", sans-serif", (Object)"Gill Sans"), new Item((Object)"\"Goudy Old Style\", Garamond, \"Big Caslon\", \"Times New Roman\", serif", (Object)"Goudy Old Style"), new Item((Object)"\"Helvetica Neue\", Helvetica, Arial, sans-serif", (Object)"Helvetica Neue"), new Item((Object)"\"Hoefler Text\", Constantia, Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", (Object)"Hoefler Text"), new Item((Object)"Impact, Haettenschweiler, \"Arial Narrow Bold\", sans-serif", (Object)"Impact"), new Item((Object)"\"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", (Object)"Lucida Sans"), new Item((Object)"\"Lucida Bright\", Georgia, serif", (Object)"Lucida Bright"), new Item((Object)"Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", (Object)"Palatino"), new Item((Object)"Segoe, \"Segoe UI\", Tahoma, Geneva, \"Nimbus Sans L\", sans-serif", (Object)"Segoe"), new Item((Object)"Tahoma, Geneva, Verdana, sans-serif", (Object)"Tahoma"), new Item((Object)"Times, \"Times New Roman\", Georgia, serif", (Object)"Times"), new Item((Object)"\"Trebuchet MS\", \"Lucida Sans Unicode\", \"Lucida Grande\", \"Lucida Sans\", Tahoma, sans-serif", (Object)"Trebuchet MS"), new Item((Object)"Verdana, Geneva, Tahoma, sans-serif", (Object)"Verdana"), new Item((Object)"", (Object)"[   Google Fonts   ]"), new Item((Object)"_Barlow", (Object)"Barlow"), new Item((Object)"_Barlow Semi Condensed", (Object)"Barlow Semi Condensed"), new Item((Object)"_Cormorant", (Object)"Cormorant"), new Item((Object)"_Dosis", (Object)"Dosis"), new Item((Object)"_Exo 2", (Object)"Exo 2"), new Item((Object)"_IBM Plex Sans", (Object)"IBM Plex Sans"), new Item((Object)"_IBM Plex Serif", (Object)"IBM Plex Serif"), new Item((Object)"_Josefin Sans", (Object)"Josefin Sans"), new Item((Object)"_Josefin Slab", (Object)"Josefin Slab"), new Item((Object)"_Lato", (Object)"Lato"), new Item((Object)"_League Spartan", (Object)"League Spartan"), new Item((Object)"_Montserrat", (Object)"Montserrat"), new Item((Object)"_Noto Serif", (Object)"Noto Serif"), new Item((Object)"_Open Sans", (Object)"Open Sans"), new Item((Object)"_Oswald", (Object)"Oswald"), new Item((Object)"_Quicksand", (Object)"Quicksand"), new Item((Object)"_Raleway", (Object)"Raleway"), new Item((Object)"_Roboto", (Object)"Roboto"), new Item((Object)"_Roboto Condensed", (Object)"Roboto Condensed"), new Item((Object)"_Roboto Slab", (Object)"Roboto Slab"), new Item((Object)"_Saira", (Object)"Saira"), new Item((Object)"_Sofia Sans", (Object)"Sofia Sans"), new Item((Object)"_Sofia Sans Condensed", (Object)"Sofia Sans Condensed"), new Item((Object)"_Source Sans 3", (Object)"Source Sans 3"), new Item((Object)"_Source Serif 4", (Object)"Source Serif 4"), new Item((Object)"_Ubuntu", (Object)"Ubuntu"), new Item((Object)"_Yanone Kaffeesatz", (Object)"Yanone Kaffeesatz"), new Item((Object)"_Work Sans", (Object)"Work Sans"), new Item((Object)"_Zilla Slab", (Object)"Zilla Slab")});
            this.fontWeight = new JComboBox<Item>(new Item[]{new Item((Object)"100", (Object)"Thin"), new Item((Object)"200", (Object)"Extra Light"), new Item((Object)"300", (Object)"Light"), new Item((Object)"400", (Object)"Regular"), new Item((Object)"500", (Object)"Medium"), new Item((Object)"600", (Object)"Semi Bold"), new Item((Object)"700", (Object)"Bold"), new Item((Object)"800", (Object)"Extra Bold"), new Item((Object)"900", (Object)"Black")});
            this.headlineFontFamily = new JComboBox<Object>(new Object[]{new Item((Object)"", (Object)("[   " + Gui.this.getText("ui.sameAsBaseFont") + "   ]")), new Item((Object)"Abril Fatface", (Object)"Abril Fatface"), new Item((Object)"Amatic SC:700", (Object)"Amatic SC Bold"), new Item((Object)"Arapey", (Object)"Arapey"), new Item((Object)"Barlow:300", (Object)"Barlow Light"), new Item((Object)"Barlow:500", (Object)"Barlow Medium"), new Item((Object)"Barlow Semi Condensed:400", (Object)"Barlow Semi Condensed"), new Item((Object)"Barlow Condensed", (Object)"Barlow Condensed"), new Item((Object)"Cantata One", (Object)"Cantata One"), new Item((Object)"Cinzel Decorative", (Object)"Cinzel Decorative"), new Item((Object)"Cormorant", (Object)"Cormorant"), new Item((Object)"Dancing Script", (Object)"Dancing Script"), new Item((Object)"Economica", (Object)"Economica"), new Item((Object)"Exo 2:300", (Object)"Exo 2"), new Item((Object)"Fauna One", (Object)"Fauna One"), new Item((Object)"Fjalla One", (Object)"Fjalla One"), new Item((Object)"Geo", (Object)"Geo"), new Item((Object)"Gilda Display", (Object)"Gilda Display"), new Item((Object)"Grand Hotel", (Object)"Grand Hotel"), new Item((Object)"Gruppo", (Object)"Gruppo"), new Item((Object)"Handlee", (Object)"Handlee"), new Item((Object)"IBM Plex Serif:300", (Object)"IBM Plex Serif"), new Item((Object)"Josefin Slab", (Object)"Josefin Slab"), new Item((Object)"Julius Sans One", (Object)"Julius Sans One"), new Item((Object)"Jura", (Object)"Jura"), new Item((Object)"Libre Baskerville", (Object)"Libre Baskerville"), new Item((Object)"Lobster", (Object)"Lobster"), new Item((Object)"Lobster Two", (Object)"Lobster Two"), new Item((Object)"Lora", (Object)"Lora"), new Item((Object)"Martel:300", (Object)"Martel Light"), new Item((Object)"Marvel:700", (Object)"Marvel Bold"), new Item((Object)"Medula One", (Object)"Medula One"), new Item((Object)"Merriweather:300", (Object)"Merriweather"), new Item((Object)"Noticia Text", (Object)"Noticia Text"), new Item((Object)"Noto Serif Display:300", (Object)"Noto Serif Light"), new Item((Object)"Oranienbaum", (Object)"Oranienbaum"), new Item((Object)"Oswald:300", (Object)"Oswald Light"), new Item((Object)"Philosopher", (Object)"Philosopher"), new Item((Object)"Poiret One", (Object)"Poiret One"), new Item((Object)"Prata", (Object)"Prata"), new Item((Object)"PT Mono", (Object)"PT Mono"), new Item((Object)"Raleway:300", (Object)"Raleway"), new Item((Object)"Raleway:600", (Object)"Raleway Bold"), new Item((Object)"Roboto Condensed", (Object)"Roboto Condensed"), new Item((Object)"Roboto Slab:300", (Object)"Roboto Slab"), new Item((Object)"Roboto Slab:600", (Object)"Roboto Slab Bold"), new Item((Object)"Rochester", (Object)"Rochester"), new Item((Object)"Saira", (Object)"Saira"), new Item((Object)"Scope One", (Object)"Scope One"), new Item((Object)"Smooch Sans", (Object)"Smooch Sans"), new Item((Object)"Sofia", (Object)"Sofia"), new Item((Object)"Sofia Sans Condensed:200", (Object)"Sofia Sans Condensed ExtraLight"), new Item((Object)"Sofia Sans Condensed:600", (Object)"Sofia Sans Condensed SemiBold"), new Item((Object)"Special Elite", (Object)"Special Elite"), new Item((Object)"Squada One", (Object)"Squada One"), new Item((Object)"Strait", (Object)"Strait"), new Item((Object)"Unica One", (Object)"Unica One"), new Item((Object)"Vidaloka", (Object)"Vidaloka"), new Item((Object)"Work Sans", (Object)"Work Sans"), new Item((Object)"Yanone Kaffeesatz:300", (Object)"Yanone Kaffeesatz"), new Item((Object)"Yanone Kaffeesatz:500", (Object)"Yanone Kaffeesatz Bold"), new Item((Object)"Zilla Slab", (Object)"Zilla Slab")});
            this.fontSuggestions = new JComboBox<Object>(new Object[]{"[" + Gui.this.getText("ui.suggestedFonts") + "]", "Barlow Semi Condensed / Barlow", "Cormorant / Zilla Slab", "Exo 2 / Exo 2", "Barlow Condensed / Roboto", "IBM Plex Serif / IBM Plex Sans", "Jura / Roboto Condensed", "Martel Light / Roboto", "Oswald Light / Sofia Sans Condensed", "Raleway / Lato", "Roboto Condensed / Roboto", "Roboto Slab / Source Serif 4", "Special Elite / Zilla Slab", "Unica One / Barlow Semi Condensed", "Yanone Kaffeesatz Bold / Barlow"});
            this.shareFacebook = new JCheckBox("Facebook", false);
            this.shareThreads = new JCheckBox("Threads", false);
            this.shareBlueSky = new JCheckBox("BlueSky", false);
            this.shareTwitter = new JCheckBox("Twitter / X", false);
            this.shareLinkedIn = new JCheckBox("LinkedIn", false);
            this.sharePinterest = new JCheckBox("Pinterest", false);
            this.shareReddit = new JCheckBox("Reddit", false);
            this.shareEmail = new JCheckBox(Gui.this.getText("ui.email"), false);
            this.shareLink = new JCheckBox(Gui.this.getText("ui.link"), false);
            this.setupMonitors = pce -> {
                JAlbum.logger.log(Level.FINE, "Setting up state monitors");
                StateMonitor.monitoring((JComponent[])new JComponent[]{this.fontSuggestions}).onChange(src -> {
                    if (Gui.this.isSkinReady() && src != null) {
                        this.setFontBoxes();
                    }
                });
                StateMonitor.monitoring((JComponent[])new JComponent[]{this.shareFacebook, this.shareTwitter}).onChange(src -> this.setMakeSlides());
            };
            this.site = new ControlPanel(){
                JComboBox<Item> language = new JComboBox<Item>(){
                    {
                        this.setModel(Languages.modelFrom((File)new File(Gui.this.context.getSkinDir(), "texts")));
                        this.insertItemAt(new Item((Object)"jalbum", (Object)("[ " + Gui.this.getText("ui.jalbumPreference") + " ]")), 0);
                        this.setSelectedIndex(0);
                    }
                };
                JSpinner albumFontSize = new JSpinner(new SpinnerNumberModel(16, 12, 20, 1));
                ControlPanel typography = new ControlPanel(){
                    JLinkLabel samplesLink;
                    {
                        this.samplesLink = new JLinkLabel("file://" + Gui.this.skinDirectory.toString().replace("\\", "/") + "/font-samples.html", Gui.this.getText("ui.fontSamples"));
                        this.setTitle(Gui.this.getText("ui.typography"));
                        this.add("", (Component)new JLabelFor(Gui.this.getText("ui.pairingSuggestions"), (JComponent)fontSuggestions));
                        this.add("tab", fontSuggestions);
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.font"), fontFamily));
                        this.add("tab", fontFamily);
                        this.add("tab", fontWeight);
                        this.add(" ", albumFontSize);
                        this.add(new JLabel("px"));
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.headlineFont"), (JComponent)headlineFontFamily));
                        this.add("tab", headlineFontFamily);
                        this.add("br tab", (Component)this.samplesLink);
                    }
                };
                JColorSelector sidebarBackgroundColor;
                JColorSelector sidebarTextColor;
                JColorSelector thumbnailsBackgroundColor;
                JColorSelector thumbnailsTextColor;
                JColorSelector lightboxBackgroundColor;
                JColorSelector lightboxTextColor;
                JColorSelector buttonBackgroundColor;
                JColorSelector buttonTextColor;
                ControlPanel design;
                {
                    this.sidebarBackgroundColor = new JColorSelector(Gui.this.getText("ui.sidebarBackground"), (JTextField)new JSmartTextField(10));
                    this.sidebarTextColor = new JColorSelector(Gui.this.getText("ui.sidebarTextColor"), (JTextField)new JSmartTextField(10));
                    this.thumbnailsBackgroundColor = new JColorSelector(Gui.this.getText("ui.thumbnailsBackground"), (JTextField)new JSmartTextField(10));
                    this.thumbnailsTextColor = new JColorSelector(Gui.this.getText("ui.thumbnailsText"), (JTextField)new JSmartTextField(10));
                    this.lightboxBackgroundColor = new JColorSelector(Gui.this.getText("ui.lightboxBackground"), (JTextField)new JSmartTextField(10));
                    this.lightboxTextColor = new JColorSelector(Gui.this.getText("ui.lightboxText"), (JTextField)new JSmartTextField(10));
                    this.buttonBackgroundColor = new JColorSelector(Gui.this.getText("ui.buttonColor"), (JTextField)new JSmartTextField(10));
                    this.buttonTextColor = new JColorSelector(Gui.this.getText("ui.buttonText"), (JTextField)new JSmartTextField(10));
                    this.design = new ControlPanel(){
                        {
                            this.setTitle(Gui.this.getText("ui.design"));
                            sidebarBackgroundColor.getTextComponent().setFont(Gui.this.mono);
                            sidebarTextColor.getTextComponent().setFont(Gui.this.mono);
                            thumbnailsBackgroundColor.getTextComponent().setFont(Gui.this.mono);
                            thumbnailsTextColor.getTextComponent().setFont(Gui.this.mono);
                            lightboxBackgroundColor.getTextComponent().setFont(Gui.this.mono);
                            lightboxTextColor.getTextComponent().setFont(Gui.this.mono);
                            buttonBackgroundColor.getTextComponent().setFont(Gui.this.mono);
                            buttonTextColor.getTextComponent().setFont(Gui.this.mono);
                            this.add("", (Component)new JLabelFor(Gui.this.getText("ui.sidebarBackground"), (JComponent)sidebarBackgroundColor));
                            this.add("tab", (Component)sidebarBackgroundColor);
                            this.add("tab", sidebarBackgroundColor.getTextComponent());
                            this.add("tab", (Component)new JLabelFor(Gui.this.getText("ui.sidebarTextColor"), (JComponent)sidebarTextColor));
                            this.add("tab", (Component)sidebarTextColor);
                            this.add("tab", sidebarTextColor.getTextComponent());
                            this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.thumbnailsBackground"), (JComponent)thumbnailsBackgroundColor));
                            this.add("tab", (Component)thumbnailsBackgroundColor);
                            this.add("tab", thumbnailsBackgroundColor.getTextComponent());
                            this.add("tab", (Component)new JLabelFor(Gui.this.getText("ui.thumbnailsText"), (JComponent)thumbnailsTextColor));
                            this.add("tab", (Component)thumbnailsTextColor);
                            this.add("tab", thumbnailsTextColor.getTextComponent());
                            this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.lightboxBackground"), (JComponent)lightboxBackgroundColor));
                            this.add("tab", (Component)lightboxBackgroundColor);
                            this.add("tab", lightboxBackgroundColor.getTextComponent());
                            this.add("tab", (Component)new JLabelFor(Gui.this.getText("ui.lightboxText"), (JComponent)lightboxTextColor));
                            this.add("tab", (Component)lightboxTextColor);
                            this.add("tab", lightboxTextColor.getTextComponent());
                            this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.buttonColor"), (JComponent)buttonBackgroundColor));
                            this.add("tab", (Component)buttonBackgroundColor);
                            this.add("tab", buttonBackgroundColor.getTextComponent());
                            this.add("tab", (Component)new JLabelFor(Gui.this.getText("ui.buttonText"), (JComponent)buttonTextColor));
                            this.add("tab", (Component)buttonTextColor);
                            this.add("tab", buttonTextColor.getTextComponent());
                        }
                    };
                    this.add("", new JLabel(Gui.this.getText("ui.language")));
                    this.add("tab", this.language);
                    this.add("br hfill", (Component)this.typography);
                    this.add("br hfill", (Component)this.design);
                }
            };
            this.sidebar = new ControlPanel(){
                ControlPanel navigationPanel = new ControlPanel(){
                    JComboBox<Item> navigationType;
                    {
                        this.navigationType = new JComboBox<Item>(new Item[]{new Item((Object)"subfolders", (Object)Gui.this.getText("ui.subfoldersOnly")), new Item((Object)"tree", (Object)Gui.this.getText("ui.folderTree")), new Item((Object)"collapsible", (Object)Gui.this.getText("ui.collapsibleTree"))});
                        this.setTitle(Gui.this.getText("ui.navigation"));
                        this.add(new JLabel(Gui.this.getText("ui.type")));
                        this.add("tab", this.navigationType);
                    }
                };
                ControlPanel sharingPanel = new ControlPanel(){
                    {
                        this.setTitle(Gui.this.getText("ui.sharing"));
                        this.add(shareFacebook);
                        this.add(shareThreads);
                        this.add(shareBlueSky);
                        this.add(shareTwitter);
                        this.add(shareLinkedIn);
                        this.add("br", sharePinterest);
                        this.add(shareReddit);
                        this.add(shareEmail);
                        this.add(shareLink);
                    }
                };
                {
                    this.add("hfill", (Component)this.navigationPanel);
                    this.add("br hfill", (Component)this.sharingPanel);
                }
            };
            this.thumbnails = new ControlPanel(){
                JComboBox<Item> thumbGap;
                JComboBox<Item> markActualThumb;
                JComboBox<Item> markVisitedThumbs;
                {
                    this.thumbGap = new JComboBox<Item>(new Item[]{new Item((Object)"", (Object)Gui.this.getText("ui.none")), new Item((Object)"small", (Object)Gui.this.getText("ui.small")), new Item((Object)"medium", (Object)Gui.this.getText("ui.medium")), new Item((Object)"large", (Object)Gui.this.getText("ui.large"))});
                    this.markActualThumb = new JComboBox<Item>(new Item[]{new Item((Object)"", (Object)Gui.this.getText("ui.none")), new Item((Object)"zoomin", (Object)Gui.this.getText("ui.zoomIn")), new Item((Object)"zoomout", (Object)Gui.this.getText("ui.zoomOut")), new Item((Object)"border", (Object)Gui.this.getText("ui.border"))});
                    this.markVisitedThumbs = new JComboBox<Item>(new Item[]{new Item((Object)"", (Object)Gui.this.getText("ui.none")), new Item((Object)"grayscale", (Object)Gui.this.getText("ui.grayscale")), new Item((Object)"fade", (Object)Gui.this.getText("ui.fade"))});
                    this.add(new JLabel(Gui.this.getText("ui.gapBetweenThumbnails")));
                    this.add("tab", this.thumbGap);
                    this.add("br", new JLabel(Gui.this.getText("ui.markActualThumbnail")));
                    this.add("tab", this.markActualThumb);
                    this.add("br", new JLabel(Gui.this.getText("ui.markVisitedThumbnails")));
                    this.add("tab", this.markVisitedThumbs);
                }
            };
            this.lightbox = new ControlPanel(){
                JSpinner transitionLength = new JSpinner(new SpinnerNumberModel(500, 100, 2000, 100));
                JSpinner slideshowDelay = new JSpinner(new SpinnerNumberModel(3000, 500, 9500, 500));
                JLabel slideshowDelayLabel;
                JCheckBox autoplayVideos;
                JCheckBox rightClickProtect;
                JComboBox<Item> lightboxBackground;
                JCheckBox showTitle;
                JCheckBox showDateRange;
                JCheckBox showItemCount;
                JCheckBox showStartSlideshow;
                JDraggableList lightboxItems;
                JCheckBox lightboxTitleFirstFound;
                JCheckBox captionCanBePlacedBeside;
                JCheckBox showMapBtn;
                JCheckBox showDownloadBtn;
                JComboBox mouseWheelAction;
                JCheckBox enableKeyboard;
                ControlPanel behaviorPanel;
                ControlPanel titlePanel;
                ControlPanel captionPanel;
                ControlPanel buttonsPanel;
                ControlPanel leftPanel;
                ControlPanel rightPanel;
                {
                    this.slideshowDelayLabel = new JLabel(Gui.this.getText("ui.slideshowInterval"));
                    this.autoplayVideos = new JCheckBox(Gui.this.getText("ui.autoStartVideos"), false);
                    this.rightClickProtect = new JCheckBox(Gui.this.getText("ui.rightClickProtect"), false);
                    this.lightboxBackground = new JComboBox<Item>(new Item[]{new Item((Object)"", (Object)Gui.this.getText("ui.empty")), new Item((Object)"firstImage", (Object)Gui.this.getText("ui.firstImage")), new Item((Object)"themeImage", (Object)Gui.this.getText("ui.themeImage"))});
                    this.showTitle = new JCheckBox(Gui.this.getText("ui.showTitleAndDescription"), true);
                    this.showDateRange = new JCheckBox(Gui.this.getText("ui.showDateRange"), false);
                    this.showItemCount = new JCheckBox(Gui.this.getText("ui.showItemCount"), false);
                    this.showStartSlideshow = new JCheckBox(Gui.this.getText("ui.showStartSlideshow"), true);
                    this.lightboxItems = new JDraggableList(new Object[]{new Item((Object)"fileTitle", (Object)Gui.this.getText("ui.title")), new Item((Object)"label", (Object)Gui.this.getText("ui.baseName")), new Item((Object)"fileName", (Object)Gui.this.getText("ui.fileName")), new Item((Object)"comment", (Object)Gui.this.getText("ui.comment")), new Item((Object)"keywords", (Object)Gui.this.getText("ui.keywords")), new Item((Object)"photodata", (Object)Gui.this.getText("ui.photodata"))}, new String[]{"fileTitle", "comment"});
                    this.lightboxTitleFirstFound = new JCheckBox(Gui.this.getText("ui.displayFirstFound"), true);
                    this.captionCanBePlacedBeside = new JCheckBox(Gui.this.getText("ui.canBePlacedBeside"), false);
                    this.showMapBtn = new JCheckBox(Gui.this.getText("ui.showMap"), false);
                    this.showDownloadBtn = new JCheckBox(Gui.this.getText("ui.showDownloadButton"), true);
                    this.mouseWheelAction = new JComboBox<Object>(new Object[]{new Item((Object)"", (Object)Gui.this.getText("ui.default")), new Item((Object)"navigation", (Object)Gui.this.getText("ui.navigation")), new Item((Object)"zoom", (Object)Gui.this.getText("ui.zoom"))});
                    this.enableKeyboard = new JCheckBox(Gui.this.getText("ui.enableKeyboard"), true);
                    this.behaviorPanel = new ControlPanel(){
                        {
                            this.setTitle(Gui.this.getText("ui.image"));
                            rightClickProtect.setToolTipText(Gui.this.getText("ui.rightClickProtectInfo"));
                            mouseWheelAction.setToolTipText(Gui.this.getText("ui.mouseWheelActionInfo"));
                            enableKeyboard.setToolTipText(Gui.this.getText("ui.enableKeyboardInfo"));
                            this.add(new JLabel(Gui.this.getText("ui.transitionLength")));
                            this.add("tab", transitionLength);
                            this.add(new JLabel("ms"));
                            this.add("br", slideshowDelayLabel);
                            this.add("tab", slideshowDelay);
                            this.add(new JLabel("ms"));
                            this.add("br", autoplayVideos);
                            this.add("br", rightClickProtect);
                            this.add("br", enableKeyboard);
                            this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.mouseWheelAction"), (JComponent)mouseWheelAction));
                            this.add("tab", mouseWheelAction);
                        }
                    };
                    this.titlePanel = new ControlPanel(){
                        {
                            this.setTitle(Gui.this.getText("ui.titlePage"));
                            this.add(new JLabel(Gui.this.getText("ui.initialBackground")));
                            this.add("tab", lightboxBackground);
                            this.add("br", showTitle);
                            this.add("br", showItemCount);
                            this.add("br", showDateRange);
                            this.add("br", showStartSlideshow);
                        }
                    };
                    this.captionPanel = new ControlPanel(){
                        {
                            this.setTitle(Gui.this.getText("ui.caption"));
                            lightboxTitleFirstFound.setToolTipText(Gui.this.getText("ui.displayFirstInfo"));
                            this.add(new JLabel(Gui.this.getText("ui.available")));
                            this.add("tab", new JLabel(Gui.this.getText("ui.used")));
                            this.add("br", new JScrollPane((Component)lightboxItems.getSecondaryList()));
                            this.add("tab", new JScrollPane((Component)lightboxItems));
                            this.add("br", lightboxTitleFirstFound);
                            this.add("br", captionCanBePlacedBeside);
                        }
                    };
                    this.buttonsPanel = new ControlPanel(){
                        {
                            this.setTitle(Gui.this.getText("ui.buttons"));
                            showMapBtn.setToolTipText(Gui.this.getText("ui.mapInfo"));
                            showDownloadBtn.setToolTipText(Gui.this.getText("ui.downloadInfo"));
                            this.add("", showMapBtn);
                            this.add("br", showDownloadBtn);
                        }
                    };
                    this.leftPanel = new ControlPanel(){
                        {
                            ((RiverLayout)this.getLayout()).setVgap(0);
                            ((RiverLayout)this.getLayout()).setHgap(0);
                            this.add("hfill", (Component)titlePanel);
                            this.add("br hfill", (Component)behaviorPanel);
                        }
                    };
                    this.rightPanel = new ControlPanel(){
                        {
                            ((RiverLayout)this.getLayout()).setVgap(0);
                            ((RiverLayout)this.getLayout()).setHgap(0);
                            this.add("hfill", (Component)captionPanel);
                            this.add("br hfill", (Component)buttonsPanel);
                        }
                    };
                    this.add("vtop", (Component)this.leftPanel);
                    this.add("tab hfill", (Component)this.rightPanel);
                }
            };
            this.advanced = new ControlPanel(){
                ControlPanel customKeysPanel = new ControlPanel(){
                    JTextArea customKeys = new JSmartTextArea(7, 20);
                    JScrollPane customKeysPane = new JScrollPane(this.customKeys);
                    {
                        this.customKeys.setEditable(true);
                        this.customKeys.setLineWrap(false);
                        this.customKeys.setFont(Gui.this.mono);
                        this.customKeys.setTabSize(2);
                        this.customKeysPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.customKeys")));
                        this.add("hfill vfill", this.customKeysPane);
                        this.add("br", new JLabel(Gui.this.getText("ui.customKeysInfo")));
                    }
                };
                ControlPanel headHookTab = new ControlPanel(){
                    JTextArea headHook = new JSmartTextArea(7, 20);
                    JScrollPane headHookPane = new JScrollPane(this.headHook);
                    {
                        this.headHook.setEditable(true);
                        this.headHook.setLineWrap(false);
                        this.headHook.setFont(Gui.this.mono);
                        this.headHook.setTabSize(2);
                        this.headHookPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.headText")));
                        this.add("hfill vfill", this.headHookPane);
                    }
                };
                ControlPanel bodyHookTab = new ControlPanel(){
                    JTextArea bodyHook = new JSmartTextArea(7, 20);
                    JScrollPane bodyHookPane = new JScrollPane(this.bodyHook);
                    {
                        this.bodyHook.setEditable(true);
                        this.bodyHook.setLineWrap(false);
                        this.bodyHook.setFont(Gui.this.mono);
                        this.bodyHook.setTabSize(2);
                        this.bodyHookPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.bodyText")));
                        this.add("hfill vfill", this.bodyHookPane);
                    }
                };
                ControlPanel cssHookTab = new ControlPanel(){
                    JTextArea cssHook = new JSmartTextArea(15, 20);
                    JScrollPane cssHookPane = new JScrollPane(this.cssHook);
                    WrappableJLabel info;
                    {
                        this.info = new WrappableJLabel("<html><i>" + Gui.this.getText("ui.cssText") + "</i></html>");
                        this.cssHook.setEditable(true);
                        this.cssHook.setLineWrap(false);
                        this.cssHook.setFont(Gui.this.mono);
                        this.cssHook.setTabSize(2);
                        this.cssHookPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.cssTitle")));
                        this.info.setPreferredWidth(700);
                        this.add("hfill vfill", this.cssHookPane);
                        this.add("br", (Component)this.info);
                    }
                };
                ControlPanel jsHookTab = new ControlPanel(){
                    JTextArea jsHook = new JSmartTextArea(15, 20);
                    JScrollPane jsHookPane = new JScrollPane(this.jsHook);
                    WrappableJLabel info;
                    {
                        this.info = new WrappableJLabel("<html><i>" + Gui.this.getText("ui.javascriptText") + "</i></html>");
                        this.jsHook.setEditable(true);
                        this.jsHook.setLineWrap(false);
                        this.jsHook.setFont(Gui.this.mono);
                        this.jsHook.setTabSize(2);
                        this.jsHookPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.javascriptTitle")));
                        this.info.setPreferredWidth(700);
                        this.add("hfill vfill", this.jsHookPane);
                        this.add("br", (Component)this.info);
                    }
                };
                JTabbedPane customCodeTabs = new JTabbedPane(){
                    {
                        this.addTab(Gui.this.getText("ui.customKeys"), Gui.icon("rename"), (Component)customKeysPanel);
                        this.addTab("<HEAD>", Gui.icon("code"), (Component)headHookTab);
                        this.addTab("<BODY>", Gui.icon("code"), (Component)bodyHookTab);
                        this.addTab("CSS", Gui.icon("css"), (Component)cssHookTab);
                        this.addTab("JavaScript", Gui.icon("javascript"), (Component)jsHookTab);
                    }
                };
                {
                    this.add("hfill vfill", this.customCodeTabs);
                    this.putClientProperty("helpPage", "http://jalbum.net/help/en/Skin/Split/Advanced/Custom_code");
                }
            };
            this.about = new ControlPanel(new BorderLayout(20, 0)){
                private final JTextArea readme;
                private final JScrollPane readmePane;
                ControlPanel info;
                {
                    this.readme = new JSmartTextArea(Gui.this.getFileContents(new File(Gui.this.skinDirectory, "readme.txt")), 20, 30);
                    this.readmePane = new JScrollPane(this.readme, 22, 31);
                    this.info = new ControlPanel(){
                        {
                            this.add("center", new JLabel(Gui.svgIcon("split-logo", new Dimension(128, 128), false)));
                            this.add("br center", new JLabel("<html><h2>" + Gui.this.skin + "</h2></html>"));
                            this.add("br center", new JLabel("Jalbum " + Gui.this.internalVersion));
                            this.add((Component)new JLinkLabel("https://jalbum.net/software/download", Gui.this.getText("ui.upgrade"), Gui.this.getText("ui.downloadJalbum")));
                            this.add("br center", new JLabel(Gui.this.skin + " skin " + Gui.this.skinVersion));
                            this.add((Component)new JLinkLabel("https://jalbum.net/skins/skin/" + Gui.this.skin, Gui.this.getText("ui.upgrade"), Gui.this.getText("ui.downloadSkin")));
                            this.add("br center", (Component)new JLinkLabel(Gui.this.supportForum, Gui.this.getText("ui.support")));
                        }
                    };
                    ((BorderLayout)this.getLayout()).setVgap(0);
                    ((BorderLayout)this.getLayout()).setHgap(0);
                    this.readme.setLineWrap(true);
                    this.readme.setWrapStyleWord(true);
                    this.readme.setEditable(false);
                    this.readme.setFont(Gui.this.mono);
                    this.info.setPreferredSize(new Dimension(240, 400));
                    this.readmePane.setPreferredSize(new Dimension(400, 320));
                    this.add((Component)this.info, "West");
                    this.add(this.readmePane);
                }
            };
            this.tabs = new JTabbedPane(){
                {
                    site.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    sidebar.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    thumbnails.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    lightbox.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    advanced.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    about.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    this.addTab("<html><h4 style='padding:3px 2px;margin:0'>" + Gui.this.getText("ui.site") + "</h4></html>", Gui.icon("settings"), (Component)site);
                    this.addTab("<html><h4 style='padding:3px 2px;margin:0'>" + Gui.this.getText("ui.sidebar") + "</h4></html>", Gui.icon("sidebar-left"), (Component)sidebar);
                    this.addTab("<html><h4 style='padding:3px 2px;margin:0'>" + Gui.this.getText("ui.thumbnails") + "</h4></html>", Gui.icon("thumbnails"), (Component)thumbnails);
                    this.addTab("<html><h4 style='padding:3px 2px;margin:0'>" + Gui.this.getText("ui.lightbox") + "</h4></html>", Gui.icon("lightbox"), (Component)lightbox);
                    this.addTab("<html><h4 style='padding:3px 2px;margin:0'>" + Gui.this.getText("ui.advanced") + "</h4></html>", Gui.icon("wrench"), (Component)advanced);
                    this.addTab("<html><h4 style='padding:3px 2px;margin:0'>" + Gui.this.getText("ui.about") + "</h4></html>", Gui.icon("skin"), (Component)about);
                }
            };
            ((RiverLayout)this.getLayout()).setVgap(0);
            ((RiverLayout)this.getLayout()).setHgap(0);
            this.tabs.setBorder(Gui.this.emptyBorder);
            this.add("vfill", this.tabs);
            Gui.this.window.addJAlbumListener((JAlbumListener)new JAlbumAdapter(){

                public void styleChanged(JAlbumEvent e) {
                    styleName.setText(Gui.this.getStyleName());
                }
            });
            Gui.this.window.addPropertyChangeListener("skinLoaded", this.setupMonitors);
            Gui.this.window.addJAlbumListener((JAlbumListener)new JAlbumAdapter(){

                public void skinChanged(JAlbumEvent e) {
                    Gui.this.window.removePropertyChangeListener("skinLoaded", setupMonitors);
                }
            });
            try {
                Gui.this.window.albumExplorer.onContextMenu(menu -> {
                    AlbumObject[] sel = Gui.this.window.albumExplorer.explorer.getSelectedAlbumObjects();
                    if (sel.length > 0) {
                        Gui.this.createMenuItemForBooleanProperty((JMenu)menu, sel, "hideLocation", Gui.this.getText("ui.hideLocation"));
                    }
                });
            }
            catch (Throwable ex) {
                JAlbum.logger.log(Level.INFO, "Right-click extension menu is available only in jAlbum v32 and newer!");
            }
            this.putClientProperty("helpPage", "http://jalbum.net/help/en/Skin/Split");
        }

        private void setFontBoxes() {
            if (this.fontSuggestions.getSelectedIndex() == 0) {
                return;
            }
            String s = this.fontSuggestions.getSelectedItem().toString();
            String hf = s.split("/")[0].trim();
            String ff = s.split("/")[1].trim();
            Gui.this.setSelectedValue(this.fontFamily, ff);
            Gui.this.setSelectedValue(this.headlineFontFamily, hf);
            this.fontSuggestions.setSelectedIndex(0);
        }

        private void setMakeSlides() {
            boolean nv;
            boolean ov = Gui.this.engine.isSlides();
            if (ov != (nv = this.shareFacebook.isSelected())) {
                try {
                    Gui.this.window.ui2Engine();
                    Gui.this.engine.setSlides(nv);
                    Gui.this.window.engine2UI();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    };

    private static Icon icon(String basename) {
        return Icons.get(Lazaicon.class, (String)("svg/" + basename + ".svg"), (int)18);
    }

    private static Icon icon(String basename, int size) {
        return Icons.get(Lazaicon.class, (String)("svg/" + basename + ".svg"), (int)size);
    }

    private static Icon svgIcon(String basename, Dimension dim) {
        return Gui.svgIcon(basename, dim, false);
    }

    private static Icon svgIcon(String basename, Dimension dim, boolean adapt) {
        DeferredSVGIcon icon = new DeferredSVGIcon(Gui.class, "graphics/" + basename + ".svg");
        icon.setAntiAlias(true);
        icon.setAdaptColors(adapt);
        icon.setPreferredSize(dim);
        icon.setAutosize(4);
        return icon;
    }

    private Object[] getPosition() {
        return new Object[]{new Item((Object)"left top", (Object)this.getText("ui.left_top")), new Item((Object)"center top", (Object)this.getText("ui.center_top")), new Item((Object)"right top", (Object)this.getText("ui.right_top")), new Item((Object)"left center", (Object)this.getText("ui.left_middle")), new Item((Object)"center center", (Object)this.getText("ui.center_middle")), new Item((Object)"right center", (Object)this.getText("ui.right_middle")), new Item((Object)"left bottom", (Object)this.getText("ui.left_bottom")), new Item((Object)"center bottom", (Object)this.getText("ui.center_bottom")), new Item((Object)"right bottom", (Object)this.getText("ui.right_bottom"))};
    }

    private void allowHTMLEditing(JSmartTextArea ta) {
        try {
            ((JSmartTextArea)ta.setAllowHTMLEditing(true)).setFullHTMLEditing(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void allowSpelling(JSmartTextArea ta) {
        try {
            ta.spelling();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String majorVersion(String s) {
        int i = s.indexOf(".");
        if (i > 0) {
            return s.substring(0, i);
        }
        return s;
    }

    private int getMajorVersion(Object v) {
        if (v == null) {
            return -1;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            try {
                return Integer.valueOf((String)v);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        if (v instanceof Double) {
            return (int)Math.floor((Double)v);
        }
        return -1;
    }

    Boolean checkBooleanProperty(AlbumObject[] sel, String pn) {
        if (sel.length > 1) {
            boolean v = (Boolean)sel[0].getProperties().get(pn, (Object)false);
            for (AlbumObject ao : sel) {
                if ((Boolean)ao.getProperties().get(pn, (Object)false) == v) continue;
                return null;
            }
            return v;
        }
        if (sel.length == 1) {
            return (Boolean)sel[0].getProperties().get(pn, (Object)false);
        }
        return null;
    }

    void createMenuItemForBooleanProperty(JMenu menu, String pn, String title) {
        this.createMenuItemForBooleanProperty(menu, this.window.albumExplorer.explorer.getSelectedAlbumObjects(), pn, title);
    }

    void createMenuItemForBooleanProperty(JMenu menu, AlbumObject[] sel, String pn, String title) {
        Boolean cv = this.checkBooleanProperty(sel, pn);
        try {
            if (cv == null) {
                JMenu subMenu = new JMenu(title);
                JMenuItem all = new JMenuItem(this.getText("ui.all"));
                all.addActionListener(ae -> {
                    for (AlbumObject ao : sel) {
                        ao.getProperties().put(pn, (Object)true);
                        ao.getProperties().save();
                    }
                });
                JMenuItem none = new JMenuItem(this.getText("ui.none"));
                none.addActionListener(ae -> {
                    for (AlbumObject ao : sel) {
                        ao.getProperties().put(pn, (Object)false);
                        ao.getProperties().save();
                    }
                });
                subMenu.add(all);
                subMenu.add(none);
                menu.add(subMenu);
            } else {
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(title, null, cv);
                menuItem.addActionListener(ae -> {
                    for (AlbumObject ao : sel) {
                        ao.getProperties().put(pn, (Object)(cv == false ? 1 : 0));
                        ao.getProperties().save();
                    }
                });
                menu.add(menuItem);
            }
        }
        catch (Throwable ex) {
            JAlbum.logger.log(Level.INFO, "Right-click menu is available only in jAlbum v32 and newer!");
        }
    }

    private boolean isSkinReady() {
        return System.currentTimeMillis() - this.skinReadyAt > 1000L;
    }

    private String getStyleName() {
        String style = this.engine.getStyle();
        return style.substring(0, style.indexOf("."));
    }

    private String getSkinName() {
        return this.engine.getSkin();
    }

    private String getLastSkinName() {
        String ls = null;
        try {
            ls = this.engine.getLastSkin();
        }
        catch (Throwable t) {
            JAlbum.logger.log(Level.FINER, "Last skin is unknown.");
        }
        return ls;
    }

    private final String unCamelCase(String s) {
        if (s.length() > 0) {
            s = s.replaceAll("([a-z])([A-Z]+)", "$1 $2");
            return Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        return "";
    }

    private final String getText(String t) {
        String s;
        try {
            s = this.texts.getString(t);
        }
        catch (MissingResourceException e) {
            JAlbum.logger.log(Level.FINE, "Missing text: \"{0}\"", t);
            if (t.startsWith("ui.")) {
                t = t.substring(3);
            }
            s = this.unCamelCase(t);
        }
        return s;
    }

    private void getFileToRes(String[] extensions, JTextField name, Component c) {
        String fn;
        this.fc.setFileFilter((FileFilter)new FileNameExtensionFilter(this.getText("ui.select"), extensions));
        int returnVal = this.fc.showOpenDialog(c);
        if (returnVal == 0 && !(fn = this.fc.getSelectedFile().toString()).trim().equals("")) {
            File src = new File(fn);
            File dst = new File(this.context.getPluginContext().getRootFolder().getFile(), "res");
            if (!dst.exists()) {
                dst.mkdir();
            }
            if (src.exists() && dst.exists()) {
                try {
                    IO.copyFile((File)src, (File)dst);
                    name.setText(src.getName());
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
        }
    }

    private String getFileContents(File f) {
        StringBuilder cont = new StringBuilder();
        String nl = System.getProperty("line.separator");
        if (f.exists()) {
            try (BufferedReader in = new BufferedReader(new FileReader(f));){
                String line;
                while ((line = in.readLine()) != null) {
                    cont.append(line);
                    cont.append(nl);
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return cont.toString();
    }

    private int setSelectedValue(JComboBox<Item> box, Object val) {
        int size = box.getItemCount();
        for (int i = 0; i < size; ++i) {
            Item it = box.getItemAt(i);
            if (!it.item.equals(val)) continue;
            box.setSelectedIndex(i);
            return i;
        }
        return -1;
    }

    private String getSelectedValue(Object o) {
        if (o instanceof JComboBox) {
            Object so = ((JComboBox)o).getSelectedItem();
            if (so instanceof Item) {
                return ((Item)so).value.toString();
            }
            return so == null ? null : so.toString();
        }
        return o == null ? null : o.toString();
    }

    public Gui() {
        this(JAlbumContext.getInstance());
    }

    public Gui(JAlbumContext context) {
        super(context);
        PluginContext pc = context.getPluginContext();
        this.skinUi.setBorder(this.emptyBorder);
        ((RiverLayout)this.getLayout()).setVgap(0);
        ((RiverLayout)this.getLayout()).setHgap(0);
        this.window.setSkinUI(this.skinUi);
        this.skinReadyAt = System.currentTimeMillis();
    }
}

