/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DataType;
import com.teamdev.jxbrowser.view.swing.internal.dnd.StringDataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.List;

final class TextDataType
extends DataType {
    private static final StringDataFlavor PLAIN_TEXT = StringDataFlavor.newInstance("text/plain");
    private static final StringDataFlavor JAVA_SERIALIZED_OBJECT = StringDataFlavor.newInstance("application/x-java-serialized-object");

    TextDataType() {
    }

    @Override
    public void fillDropData(Transferable transferable, DropData.Builder dropData) {
        for (StringDataFlavor supportedFlavor : this.supportedFlavors()) {
            if (!supportedFlavor.isPresentedIn(transferable)) continue;
            String text = supportedFlavor.read(transferable);
            dropData.setText(text);
            return;
        }
    }

    @Override
    public void fillMetadata(DropMetadata.Builder metadata) {
        metadata.setContainsText(true);
    }

    protected List<StringDataFlavor> supportedFlavors() {
        return ImmutableList.of((Object)PLAIN_TEXT, (Object)JAVA_SERIALIZED_OBJECT);
    }
}

