/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.BuiltInCursors;
import com.teamdev.jxbrowser.ui.internal.CursorFactory;
import com.teamdev.jxbrowser.view.swing.internal.BuiltInCursors;
import com.teamdev.jxbrowser.view.swing.internal.graphics.CursorImage;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class SwingCursorFactory
extends CursorFactory<Cursor, Integer> {
    SwingCursorFactory() {
        super(BuiltInCursors.instance());
    }

    protected Cursor toolkitCursor(Integer cursorType) {
        return Cursor.getPredefinedCursor(cursorType);
    }

    protected Cursor builtInCursor(BuiltInCursors.BuiltInCursorData data) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(data.resource());
        java.awt.Point hotspot = new java.awt.Point(data.hotspot().x(), data.hotspot().y());
        return toolkit.createCustomCursor(image, hotspot, data.type().name());
    }

    protected Cursor customCursor(Bitmap bitmap, Point hotspot) {
        if (this.customCursorForbiddenByOs(bitmap.size())) {
            return this.defaultCursor();
        }
        BufferedImage image = CursorImage.toToolkit(bitmap);
        return SwingCursorFactory.cursorFromImage(image, hotspot);
    }

    protected Cursor defaultCursor() {
        return Cursor.getDefaultCursor();
    }

    private boolean customCursorForbiddenByOs(Size cursorSize) {
        Dimension bestCursorSize = Toolkit.getDefaultToolkit().getBestCursorSize(cursorSize.width(), cursorSize.width());
        return (int)bestCursorSize.getWidth() == 0 && (int)bestCursorSize.getHeight() == 0;
    }

    private static Cursor cursorFromImage(BufferedImage image, Point hotspot) {
        java.awt.Point awtHotspot = new java.awt.Point(hotspot.x(), hotspot.y());
        return Toolkit.getDefaultToolkit().createCustomCursor(image, awtHotspot, "customCursor");
    }
}

