/*
 * Decompiled with CFR 0.152.
 */
package projector;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import se.datadosen.component.JPlaylist;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JCustomPanel;
import se.datadosen.util.SmartResourceBundle;

public class ImageDataUI
extends JCustomPanel {
    JPlaylist backgroundAudioLocal = new JPlaylist();
    JLabel backgroundAudioLabel = new JLabel();
    JCheckBox panorama = new JCheckBox();
    JCheckBox hideLocation = new JCheckBox();
    JLabel customSlideshowDelayLabel = new JLabel();
    JTextField customSlideshowDelay = new JTextField(4);
    JLabel customTransitionSpeedLabel = new JLabel();
    JTextField customTransitionSpeed = new JTextField(4);

    public void setAlbumObject(AlbumObject ao) {
        super.setAlbumObject(ao);
        if (ao != null) {
            Category cc = ao.getCategory();
            boolean lightboxable = cc != Category.folder && cc != Category.webPage && cc != Category.webLocation;
            this.backgroundAudioLocal.setVisible(cc == Category.folder);
            this.backgroundAudioLabel.setVisible(cc == Category.folder);
            this.panorama.setVisible(lightboxable);
            this.hideLocation.setVisible(lightboxable);
            this.customSlideshowDelayLabel.setVisible(lightboxable);
            this.customSlideshowDelay.setVisible(lightboxable);
            this.customTransitionSpeedLabel.setVisible(lightboxable);
            this.customTransitionSpeed.setVisible(lightboxable);
        }
    }

    public ImageDataUI(JAlbumContext context, SmartResourceBundle texts) {
        super(context);
        this.backgroundAudioLabel.setText(texts.getString("ui.backgroundMusic"));
        this.panorama.setText(texts.getString("ui.panorama"));
        this.hideLocation.setText(texts.getString("ui.hideLocation"));
        this.customSlideshowDelayLabel.setText(texts.getString("ui.slideshowDelay"));
        this.customSlideshowDelay.setToolTipText(texts.getString("ui.customSlideshowDelayInfo") + " " + texts.getString("ui.leaveEmptyForDefault"));
        this.customTransitionSpeedLabel.setText(texts.getString("ui.transitionSpeed"));
        this.customTransitionSpeed.setToolTipText(texts.getString("ui.customTransitionSpeedInfo") + " " + texts.getString("ui.leaveEmptyForDefault"));
        this.add("", this.backgroundAudioLabel);
        this.add("br hfill", (Component)this.backgroundAudioLocal);
        this.add("", this.panorama);
        this.add("br", this.hideLocation);
        this.add("br", this.customSlideshowDelayLabel);
        this.add("tab", this.customSlideshowDelay);
        this.add("br", this.customTransitionSpeedLabel);
        this.add("tab", this.customTransitionSpeed);
        this.init();
    }
}

