/*
 * Decompiled with CFR 0.152.
 */
package projector;

import edu.stanford.ejalbert.BrowserLauncher;
import icons.Lazaicon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.jalbum.browser.WebViewBrowser;
import net.jalbum.component.JDraggableList;
import projector.GuiBase;
import projector.ImageDataUI;
import projector.SkinModel;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.DeferredSVGIcon;
import se.datadosen.component.FileChooser;
import se.datadosen.component.JAlphaColorSelector;
import se.datadosen.component.JColorSelector;
import se.datadosen.component.JLabelFor;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JPlaylist;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.StateMonitor;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.EditPanel;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.jalbum.event.JAlbumListener;
import se.datadosen.tags.ElementException;
import se.datadosen.util.IO;
import se.datadosen.util.Item;
import se.datadosen.util.Languages;
import se.datadosen.util.NameValue;
import se.datadosen.util.VersionNumber;

public class Gui
extends GuiBase {
    private long skinReadyAt = Long.MAX_VALUE;
    private final VersionNumber jalbumVersion = new VersionNumber(AlbumBean.getInternalVersion());
    private final String skinVer = new SkinProperties(this.skinDirectory).getProperty("version");
    private final String supportForum = new SkinProperties(this.skinDirectory).getProperty("supportForum");
    private final String helpRoot = "http://jalbum.net/help/en/Skin/" + this.skin + "/";
    private final int uiHeight = 560;
    private final int uiWidth = 600;
    private final int previewWidth = 520;
    private final String tabStyle = "style='padding:3px 4px;margin:3px 4px;'";
    private final String CUSTOM = "<!--custom-->";
    private String license = this.licenseManager.isLicenseValid() ? this.licenseManager.getLicenseType() : "";
    private boolean commercialUseAllowed = this.license != null && this.license.length() > 0 && "pro".equals(this.license);
    private Font mono = new Font("monospaced", 0, 12);
    private Border emptyBorder = BorderFactory.createEmptyBorder();
    private final Double FULLY_TRANSP = 1.0E-4;
    private final Double FULLY_OPAQUE = 0.9999;
    private static final Pattern RGBA_PATTERN = Pattern.compile("rgba?\\((\\d+),(\\d+),(\\d+)(,([\\d\\.]+))?\\)");
    private final String[] imageFiles = new String[]{"jpg", "jpeg", "png", "gif", "svg"};
    private final FileChooser fc = ChooserFactory.createFileChooser((Window)this.window);
    private StateMonitor commercialMonitor = new StateMonitor(){

        public void onChange() {
            if (((JCheckBox)this.source).isSelected() && !Gui.this.commercialUseAllowed) {
                if (Gui.this.isSkinReady()) {
                    Object[] options = new Object[]{Gui.this.getText("ui.signUp"), Gui.this.getText("ui.noThanks")};
                    int n = JOptionPane.showOptionDialog((Component)Gui.this.window, Gui.this.getText("ui.licenseWarningText"), Gui.this.getText("ui.licenseWarningTitle"), 0, 1, null, options, options[1]);
                    if (n == 0) {
                        try {
                            BrowserLauncher.openURL((String)(JAlbumSite.getTrueInstance().getMyJAlbumUpgradeUrl() + "/?referrer=" + Gui.this.skin + Gui.this.attemptSignIn()));
                        }
                        catch (IOException | ElementException throwable) {
                            // empty catch block
                        }
                    }
                }
                ((JCheckBox)this.source).setSelected(false);
            }
        }
    };
    private Date skinLoadedOn = new Date();
    ControlPanel skinUi = new ControlPanel(){
        private Icon infoIcon = Gui.access$400("info");
        private Icon mandatory = Gui.access$500("asterisk", new Dimension(16, 16));
        private boolean skinChangeReported = false;
        private JTextField styleName = new JTextField(Gui.access$600(Gui.this));
        JTextField majorSkinVersion = new JTextField(Gui.access$800(Gui.this, Gui.access$700(Gui.this)));
        JTextField facebookAppId = new JSmartTextField("", 24);
        JColorSelector backgroundColor = new JAlphaColorSelector(Gui.access$200(Gui.this, "ui.backgroundColor"), (JTextField)new JSmartTextField("#222222", 10));
        JTextField backgroundImageName = new JSmartTextField(16);
        JComboBox backgroundPos = new JComboBox<Object>(Gui.access$900(Gui.this));
        JComboBox backgroundRepeat = new JComboBox<Object>(new Object[]{new Item((Object)"no-repeat", (Object)Gui.access$200(Gui.this, "ui.no_repeat")), new Item((Object)"repeat-x", (Object)Gui.access$200(Gui.this, "ui.repeat_x")), new Item((Object)"repeat-y", (Object)Gui.access$200(Gui.this, "ui.repeat_y")), new Item((Object)"repeat", (Object)Gui.access$200(Gui.this, "ui.repeat_both")), new Item((Object)"stretch", (Object)Gui.access$200(Gui.this, "ui.stretch"))});
        JTextField sidebarBackgroundImageName = new JSmartTextField(16);
        JColorSelector sidebarBackgroundColor = new JAlphaColorSelector(Gui.access$200(Gui.this, "ui.sidebar"), (JTextField)new JSmartTextField("#ff111111", 10));
        JColorSelector heroBackgroundColor = new JAlphaColorSelector(Gui.access$200(Gui.this, "ui.coverPage"), (JTextField)new JSmartTextField("#88111111", 10));
        JColorSelector heroTextColor = new JColorSelector(Gui.access$200(Gui.this, "ui.textColor"), (JTextField)new JSmartTextField("#bbbbbb", 10));
        JTextField heroBackgroundImageName = new JSmartTextField(16);
        JComboBox heroBackgroundPos = new JComboBox<Object>(Gui.access$900(Gui.this));
        JComboBox heroBackgroundRepeat = new JComboBox<Object>(new Object[]{new Item((Object)"no-repeat", (Object)Gui.access$200(Gui.this, "ui.no_repeat")), new Item((Object)"repeat-x", (Object)Gui.access$200(Gui.this, "ui.repeat_x")), new Item((Object)"repeat-y", (Object)Gui.access$200(Gui.this, "ui.repeat_y")), new Item((Object)"repeat", (Object)Gui.access$200(Gui.this, "ui.repeat_both")), new Item((Object)"stretch", (Object)Gui.access$200(Gui.this, "ui.stretch"))});
        JColorSelector linkColor = new JColorSelector(Gui.access$200(Gui.this, "ui.linkColor"), (JTextField)new JSmartTextField("#dddddd", 10));
        JColorSelector hoverColor = new JColorSelector(Gui.access$200(Gui.this, "ui.hoverColor"), (JTextField)new JSmartTextField("#ffffff", 10));
        JColorSelector buttonColor = new JAlphaColorSelector(Gui.access$200(Gui.this, "ui.button"), (JTextField)new JSmartTextField("#2199e8", 10));
        private final JComboBox fontSuggestions = new JComboBox<Object>(new Object[]{"[" + Gui.access$200(Gui.this, "ui.suggestedFonts") + "]", "Oswald / Helvetica Neue", "Barlow Semi Condensed Light / Barlow Light", "Cinzel Decorative / Raleway", "Dosis Bold / Montserrat", "Exo 2 / Exo 2", "Fjalla One / Roboto", "IBM Plex Serif / IBM Plex Sans", "Jura / Roboto Condensed", "Martel / Roboto", "Merriweather / Merriweather Sans", "Oswald / Open Sans", "Raleway / Open Sans", "Roboto Condensed / Roboto", "Roboto Slab / Montserrat", "Special Elite / Yanone Kaffeesatz", "Unica One / Lato", "Yanone Kaffeesatz Bold / Muli"});
        JComboBox fontFamily = new JComboBox<Object>(new Object[]{new Item((Object)"Arial, \"Helvetica Neue\", Helvetica, sans-serif", (Object)"Arial"), new Item((Object)"Baskerville, \"Baskerville Old Face\", \"Hoefler Text\", Garamond, \"Times New Roman\", serif", (Object)"Baskerville"), new Item((Object)"Calibri, Candara, Segoe, \"Segoe UI\", Optima, Arial, sans-serif", (Object)"Calibri"), new Item((Object)"Cambria, Georgia, Times, \"Times New Roman\", serif", (Object)"Cambria"), new Item((Object)"\"Century Gothic\", \"Apple Gothic\", \"Goudy Old Style\", sans-serif", (Object)"Century Gothic"), new Item((Object)"\"Comic Sans MS\", cursive", (Object)"Comic Sans"), new Item((Object)"Consolas, \"Lucida Console\", Monaco, monospace", (Object)"Consolas"), new Item((Object)"Constantia, Palatino, \"Palatino Linotype\", \"Palatino LT STD\", Georgia, serif", (Object)"Constantia"), new Item((Object)"\"Copperplate Light\", \"Copperplate Gothic Light\", serif", (Object)"Copperplate Light"), new Item((Object)"\"Courier New\", Courier, monospace", (Object)"Courier New"), new Item((Object)"\"Franklin Gothic Medium\", \"Arial Narrow Bold\", Arial, sans-serif", (Object)"Franklin Gothic"), new Item((Object)"Futura, \"Century Gothic\", AppleGothic, sans-serif", (Object)"Futura"), new Item((Object)"Garamond, \"Hoefler Text\", Times New Roman, Times, serif", (Object)"Garamond"), new Item((Object)"Geneva, \"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", (Object)"Geneva"), new Item((Object)"Georgia, Palatino, \"Palatino Linotype\", Times, \"Times New Roman\", serif", (Object)"Georgia"), new Item((Object)"\"Gill Sans\", \"Gill Sans MT\", Calibri, \"Trebuchet MS\", sans-serif", (Object)"Gill Sans"), new Item((Object)"\"Goudy Old Style\", Garamond, \"Big Caslon\", \"Times New Roman\", serif", (Object)"Goudy Old Style"), new Item((Object)"\"Helvetica Neue\", Helvetica, Arial, sans-serif", (Object)"Helvetica Neue"), new Item((Object)"\"Hoefler Text\", Constantia, Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", (Object)"Hoefler Text"), new Item((Object)"Impact, Haettenschweiler, \"Arial Narrow Bold\", sans-serif", (Object)"Impact"), new Item((Object)"\"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", (Object)"Lucida Sans"), new Item((Object)"\"Lucida Bright\", Georgia, serif", (Object)"Lucida Bright"), new Item((Object)"Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", (Object)"Palatino"), new Item((Object)"Segoe, \"Segoe UI\", Tahoma, Geneva, \"Nimbus Sans L\", sans-serif", (Object)"Segoe"), new Item((Object)"Tahoma, Geneva, Verdana, sans-serif", (Object)"Tahoma"), new Item((Object)"Times, \"Times New Roman\", Georgia, serif", (Object)"Times"), new Item((Object)"\"Trebuchet MS\", \"Lucida Sans Unicode\", \"Lucida Grande\", \"Lucida Sans\", Tahoma, sans-serif", (Object)"Trebuchet MS"), new Item((Object)"Verdana, Geneva, Tahoma, sans-serif", (Object)"Verdana"), new Item((Object)"Alegreya Sans:300,300i,500,500i", (Object)"Alegreya Sans Light"), new Item((Object)"Barlow:300,300i,600,600i", (Object)"Barlow Light"), new Item((Object)"Barlow:400,400i,700,700i", (Object)"Barlow"), new Item((Object)"Barlow Semi Condensed:300,300i,500,500i", (Object)"Barlow Semi Condensed"), new Item((Object)"Exo 2:300,300i,600,600i", (Object)"Exo 2"), new Item((Object)"Fira Sans:300,300i,600,600i", (Object)"Fira Sans"), new Item((Object)"IBM Plex Sans:300,300i,600,600i", (Object)"IBM Plex Sans"), new Item((Object)"Josefin Sans:300,300i,600,600i", (Object)"Josefin Sans"), new Item((Object)"Josefin Slab:300,300i,600,600i", (Object)"Josefin Slab"), new Item((Object)"Lato:300,300i,700,700i", (Object)"Lato"), new Item((Object)"Merriweather Sans:300,300i,700,700i", (Object)"Merriweather Sans"), new Item((Object)"Merriweather:300,300i,700,700i", (Object)"Merriweather Serif"), new Item((Object)"Montserrat:300,300i,600,600i", (Object)"Montserrat"), new Item((Object)"Muli:300,300i,700,700i", (Object)"Muli"), new Item((Object)"Open Sans:300,300i,600,600i", (Object)"Open Sans"), new Item((Object)"Raleway:300,300i,600,600i", (Object)"Raleway"), new Item((Object)"Roboto:300,300i,500,500i", (Object)"Roboto"), new Item((Object)"Roboto Condensed:300,300i,700,700i", (Object)"Roboto Condensed"), new Item((Object)"Source Sans Pro:300,300i,600,600i", (Object)"Source Sans Pro"), new Item((Object)"Yanone Kaffeesatz:300,500", (Object)"Yanone Kaffeesatz")});
        JComboBox headlineFont = new JComboBox<Object>(new Object[]{new Item((Object)"", (Object)("[ " + Gui.access$200(Gui.this, "ui.sameAsBaseFont") + " ]")), new Item((Object)"Abril Fatface", (Object)"Abril Fatface"), new Item((Object)"Alex Brush", (Object)"Alex Brush"), new Item((Object)"Amaranth", (Object)"Amaranth"), new Item((Object)"Amatic SC:700", (Object)"Amatic SC Bold"), new Item((Object)"Anton", (Object)"Anton"), new Item((Object)"Arapey", (Object)"Arapey"), new Item((Object)"Barlow:300", (Object)"Barlow Light"), new Item((Object)"Barlow:500", (Object)"Barlow Medium"), new Item((Object)"Barlow Semi Condensed:300", (Object)"Barlow Semi Condensed Light"), new Item((Object)"Barlow Condensed", (Object)"Barlow Condensed"), new Item((Object)"Cantata One", (Object)"Cantata One"), new Item((Object)"Cinzel Decorative", (Object)"Cinzel Decorative"), new Item((Object)"Cookie", (Object)"Cookie"), new Item((Object)"Dancing Script", (Object)"Dancing Script"), new Item((Object)"Dynalight", (Object)"Dynalight"), new Item((Object)"Dosis:600", (Object)"Dosis Bold"), new Item((Object)"Economica", (Object)"Economica"), new Item((Object)"Emilys Candy", (Object)"Emilys Candy"), new Item((Object)"Euphoria Script", (Object)"Euphoria Script"), new Item((Object)"Exo 2:300", (Object)"Exo 2"), new Item((Object)"Fauna One", (Object)"Fauna One"), new Item((Object)"Fjalla One", (Object)"Fjalla One"), new Item((Object)"Fredericka the Great", (Object)"Fredericka the Great"), new Item((Object)"Geo", (Object)"Geo"), new Item((Object)"Gilda Display", (Object)"Gilda Display"), new Item((Object)"Grand Hotel", (Object)"Grand Hotel"), new Item((Object)"Great Vibes", (Object)"Great Vibes"), new Item((Object)"Gruppo", (Object)"Gruppo"), new Item((Object)"Handlee", (Object)"Handlee"), new Item((Object)"IBM Plex Serif:300", (Object)"IBM Plex Serif"), new Item((Object)"IM Fell English", (Object)"IM Fell English"), new Item((Object)"Italiana", (Object)"Italiana"), new Item((Object)"Josefin Slab", (Object)"Josefin Slab"), new Item((Object)"Julius Sans One", (Object)"Julius Sans One"), new Item((Object)"Jura", (Object)"Jura"), new Item((Object)"La Belle Aurore", (Object)"La Belle Aurore"), new Item((Object)"Libre Baskerville", (Object)"Libre Baskerville"), new Item((Object)"Lobster", (Object)"Lobster"), new Item((Object)"Lobster Two", (Object)"Lobster Two"), new Item((Object)"Lora", (Object)"Lora"), new Item((Object)"Maiden Orange", (Object)"Maiden Orange"), new Item((Object)"Martel:300", (Object)"Martel"), new Item((Object)"Marvel:700", (Object)"Marvel Bold"), new Item((Object)"Medula One", (Object)"Medula One"), new Item((Object)"Merriweather:300", (Object)"Merriweather"), new Item((Object)"Mountains of Christmas", (Object)"Mountains of Christmas"), new Item((Object)"Noticia Text", (Object)"Noticia Text"), new Item((Object)"Noto Serif Display:300", (Object)"Noto Serif Light"), new Item((Object)"Old Standard TT", (Object)"Old Standard TT"), new Item((Object)"Oranienbaum", (Object)"Oranienbaum"), new Item((Object)"Oswald", (Object)"Oswald"), new Item((Object)"Philosopher", (Object)"Philosopher"), new Item((Object)"Poiret One", (Object)"Poiret One"), new Item((Object)"Prata", (Object)"Prata"), new Item((Object)"Princess Sofia", (Object)"Princess Sofia"), new Item((Object)"PT Mono", (Object)"PT Mono"), new Item((Object)"PT Sans Narrow", (Object)"PT Sans Narrow"), new Item((Object)"Raleway:300", (Object)"Raleway"), new Item((Object)"Raleway:600", (Object)"Raleway Bold"), new Item((Object)"Roboto Condensed", (Object)"Roboto Condensed"), new Item((Object)"Roboto Slab:300", (Object)"Roboto Slab"), new Item((Object)"Roboto Slab:600", (Object)"Roboto Slab Bold"), new Item((Object)"Rochester", (Object)"Rochester"), new Item((Object)"Shadows Into Light Two", (Object)"Shadows Into Light Two"), new Item((Object)"Scope One", (Object)"Scope One"), new Item((Object)"Six Caps", (Object)"Six Caps"), new Item((Object)"Sofia", (Object)"Sofia"), new Item((Object)"Sorts Mill Goudy", (Object)"Sorts Mill Goudy"), new Item((Object)"Special Elite", (Object)"Special Elite"), new Item((Object)"Squada One", (Object)"Squada One"), new Item((Object)"Strait", (Object)"Strait"), new Item((Object)"Unica One", (Object)"Unica One"), new Item((Object)"Vidaloka", (Object)"Vidaloka"), new Item((Object)"Yanone Kaffeesatz:300", (Object)"Yanone Kaffeesatz"), new Item((Object)"Yanone Kaffeesatz:500", (Object)"Yanone Kaffeesatz Bold")});
        JCheckBox folderTitleSameAsHeadline = new JCheckBox(Gui.access$200(Gui.this, "ui.sameAsHeadline"), true);
        JComboBox heroType = new JComboBox<Object>(new Object[]{new Item((Object)"fullwidth", (Object)Gui.access$200(Gui.this, "ui.fullWidth")), new Item((Object)"card", (Object)Gui.access$200(Gui.this, "ui.card")), new Item((Object)"turntable", (Object)Gui.access$200(Gui.this, "ui.turntable"))});
        JComboBox folderThumbType = new JComboBox<Object>(new Object[]{new Item((Object)"circle", (Object)Gui.access$200(Gui.this, "ui.circle")), new Item((Object)"rounded", (Object)Gui.access$200(Gui.this, "ui.rounded")), new Item((Object)"square", (Object)Gui.access$200(Gui.this, "ui.square"))});
        JCheckBox showShare = new JCheckBox(Gui.access$200(Gui.this, "ui.share"), true);
        JCheckBox shareFacebook = new JCheckBox("Facebook");
        JCheckBox shareThreads = new JCheckBox("Threads");
        JCheckBox shareBluesky = new JCheckBox("Bluesky");
        JCheckBox writeSitemapXml = new JCheckBox(Gui.access$200(Gui.this, "ui.createSitemapXml"));
        JCheckBox sitemapIncludeSlides = new JCheckBox(Gui.access$200(Gui.this, "ui.includeSlides"), true);
        private WebViewBrowser designPreview = new WebViewBrowser();
        private PropertyChangeListener setupMonitors = pce -> {
            StateMonitor.monitoring((JComponent[])new JComponent[]{this.fontSuggestions}).onChange(src -> {
                if (Gui.this.isSkinReady() && src != null) {
                    this.setFontBoxes();
                }
            });
            StateMonitor.monitoring((JComponent[])new JComponent[]{this.shareFacebook, this.shareThreads, this.shareBluesky, this.showShare, this.writeSitemapXml, this.sitemapIncludeSlides}).onChange(src -> this.setMakeSlides());
            StateMonitor.monitoring((JComponent[])new JComponent[]{this.styleName, this.backgroundColor, this.backgroundPos, this.backgroundRepeat, this.heroBackgroundColor, this.heroBackgroundPos, this.heroBackgroundRepeat, this.sidebarBackgroundColor, this.heroTextColor, this.linkColor, this.hoverColor, this.buttonColor, this.fontFamily, this.headlineFont, this.folderTitleSameAsHeadline, this.heroType, this.folderThumbType}).onChange(src -> {
                if (Gui.this.isSkinReady() && src != null) {
                    this.refreshDesignPreview();
                }
            });
            this.refreshDesignPreview();
        };
        ControlPanel pageDesign = new ControlPanel(){
            JComboBox<Item> language = new JComboBox<Item>(){
                {
                    this.setModel(Languages.modelFrom((File)new File(Gui.this.skinDirectory, "texts")));
                    this.insertItemAt(new Item((Object)"jalbum", (Object)("[ " + Gui.this.getText("ui.jAlbumPreference") + " ]")), 0);
                    this.setSelectedIndex(0);
                }
            };
            JComboBox modalWindowsTheme;
            JComboBox iconStyle;
            ControlPanel pageBackground;
            ControlPanel sidebarBackground;
            ControlPanel heroBackground;
            JTabbedPane backgroundTabs;
            ControlPanel siteSettings;
            {
                this.modalWindowsTheme = new JComboBox<Object>(new Object[]{new Item((Object)"auto", (Object)Gui.this.getText("ui.auto")), new Item((Object)"light", (Object)Gui.this.getText("ui.light")), new Item((Object)"dark", (Object)Gui.this.getText("ui.dark"))});
                this.iconStyle = new JComboBox<Object>(new Object[]{new Item((Object)"thin", (Object)Gui.this.getText("ui.thin")), new Item((Object)"fat", (Object)Gui.this.getText("ui.fat"))});
                this.pageBackground = new ControlPanel(){
                    JButton selectImage = new JButton();
                    {
                        this.selectImage.setText(Gui.this.getText("ui.select"));
                        this.selectImage.addActionListener(e -> Gui.this.getFileToRes(Gui.this.imageFiles, backgroundImageName, (Component)Gui.this.skinUi));
                        backgroundColor.setToolTipText(Gui.this.getText("ui.backgroundColorInfo"));
                        backgroundColor.getTextComponent().setFont(Gui.this.mono);
                        this.add("", (Component)new JLabelFor(Gui.this.getText("ui.backgroundColor"), (JComponent)backgroundColor));
                        this.add("tab", (Component)backgroundColor);
                        this.add("tab", backgroundColor.getTextComponent());
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.backgroundImage"), (JComponent)backgroundImageName));
                        this.add("tab", backgroundImageName);
                        this.add("", this.selectImage);
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.position"), (JComponent)backgroundPos));
                        this.add("tab", backgroundPos);
                        this.add(" ", backgroundRepeat);
                    }
                };
                this.sidebarBackground = new ControlPanel(){
                    JButton selectImage = new JButton();
                    {
                        this.selectImage.setText(Gui.this.getText("ui.select"));
                        this.selectImage.addActionListener(e -> Gui.this.getFileToRes(Gui.this.imageFiles, sidebarBackgroundImageName, (Component)Gui.this.skinUi));
                        sidebarBackgroundColor.getTextComponent().setFont(Gui.this.mono);
                        sidebarBackgroundColor.setToolTipText(Gui.this.getText("ui.sidebarColorInfo"));
                        this.add("", (Component)new JLabelFor(Gui.this.getText("ui.backgroundColor"), (JComponent)sidebarBackgroundColor));
                        this.add("tab", (Component)sidebarBackgroundColor);
                        this.add("tab", sidebarBackgroundColor.getTextComponent());
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.backgroundImage"), (JComponent)sidebarBackgroundImageName));
                        this.add("tab", sidebarBackgroundImageName);
                        this.add("", this.selectImage);
                    }
                };
                this.heroBackground = new ControlPanel(){
                    JButton selectImage = new JButton();
                    {
                        heroBackgroundColor.setToolTipText(Gui.this.getText("ui.coverColorInfo"));
                        heroBackgroundColor.getTextComponent().setFont(Gui.this.mono);
                        heroTextColor.getTextComponent().setFont(Gui.this.mono);
                        heroTextColor.setToolTipText(Gui.this.getText("ui.textColorInfo"));
                        this.selectImage.setText(Gui.this.getText("ui.select"));
                        this.selectImage.addActionListener(e -> Gui.this.getFileToRes(Gui.this.imageFiles, heroBackgroundImageName, (Component)Gui.this.skinUi));
                        this.add("", (Component)new JLabelFor(Gui.this.getText("ui.backgroundColor"), (JComponent)heroBackgroundColor));
                        this.add("tab", (Component)heroBackgroundColor);
                        this.add("tab", heroBackgroundColor.getTextComponent());
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.textColor"), (JComponent)heroTextColor));
                        this.add("tab", (Component)heroTextColor);
                        this.add("tab", heroTextColor.getTextComponent());
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.backgroundImage"), (JComponent)heroBackgroundImageName));
                        this.add("tab", heroBackgroundImageName);
                        this.add("", this.selectImage);
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.position"), (JComponent)heroBackgroundPos));
                        this.add("tab", heroBackgroundPos);
                        this.add(" ", heroBackgroundRepeat);
                    }
                };
                this.backgroundTabs = new JTabbedPane(){
                    {
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.coverPage") + "</h4></html>", Gui.icon("hero"), (Component)heroBackground);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.sidebar") + "</h4></html>", Gui.icon("sidebar-left"), (Component)sidebarBackground);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.lightbox") + "</h4></html>", Gui.icon("lightbox"), (Component)pageBackground);
                    }
                };
                this.siteSettings = new ControlPanel(){
                    {
                        language.setToolTipText(Gui.this.getText("ui.languageInfo"));
                        buttonColor.getTextComponent().setFont(Gui.this.mono);
                        linkColor.setToolTipText(Gui.this.getText("ui.linkColorInfo"));
                        linkColor.getTextComponent().setFont(Gui.this.mono);
                        hoverColor.setToolTipText(Gui.this.getText("ui.hoverColorInfo"));
                        hoverColor.getTextComponent().setFont(Gui.this.mono);
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.language"), language));
                        this.add("tab", language);
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.linkColor"), (JComponent)linkColor));
                        this.add("tab", (Component)linkColor);
                        this.add("tab", linkColor.getTextComponent());
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.hoverColor"), (JComponent)hoverColor));
                        this.add("tab", (Component)hoverColor);
                        this.add("tab", hoverColor.getTextComponent());
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.button"), (JComponent)buttonColor));
                        this.add("tab", (Component)buttonColor);
                        this.add("tab", buttonColor.getTextComponent());
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.modalWindowsTheme"), (JComponent)modalWindowsTheme));
                        this.add("tab", modalWindowsTheme);
                        this.add("br", new JLabel(Gui.this.getText("ui.iconStyle")));
                        this.add("tab", iconStyle);
                    }
                };
                ((RiverLayout)this.getLayout()).setVgap(0);
                ((RiverLayout)this.getLayout()).setHgap(0);
                this.add("hfill", (Component)this.siteSettings);
                this.add("br hfill", this.backgroundTabs);
            }
        };
        ControlPanel typography = new ControlPanel(){
            {
                headlineFont.setEditable(true);
                this.add("", (Component)new JLabelFor(Gui.this.getText("ui.headlineFamily"), (JComponent)headlineFont));
                this.add("tab", headlineFont);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.fontFamily"), (JComponent)fontFamily));
                this.add("tab", fontFamily);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.pairingSuggestions"), (JComponent)fontSuggestions));
                this.add("tab", fontSuggestions);
            }
        };
        ControlPanel coverHeader = new ControlPanel(){
            JTextField logoName = new JSmartTextField(16);
            JButton selectLogo;
            JCheckBox showBreadcrumbPath;
            ControlPanel topMenu;
            JSmartTextArea header;
            JScrollPane headerPane;
            {
                this.selectLogo = new JButton(Gui.this.getText("ui.select"));
                this.showBreadcrumbPath = new JCheckBox(Gui.this.getText("ui.showBreadcrumbPath"));
                this.topMenu = new ControlPanel(Gui.this.getText("ui.topMenu")){
                    JCheckBox topMenuIncludeFolders;
                    JCheckBox topMenuIncludePages;
                    JCheckBox topMenuIncludeWebLocations;
                    {
                        this.topMenuIncludeFolders = new JCheckBox(Gui.this.getText("ui.includeFolders"));
                        this.topMenuIncludePages = new JCheckBox(Gui.this.getText("ui.includePages"));
                        this.topMenuIncludeWebLocations = new JCheckBox(Gui.this.getText("ui.includeWebLocations"));
                        this.add("", this.topMenuIncludeFolders);
                        this.add("br", this.topMenuIncludePages);
                        this.add("br", this.topMenuIncludeWebLocations);
                    }
                };
                this.header = new JSmartTextArea(4, 20);
                this.headerPane = new JScrollPane((Component)this.header);
                this.selectLogo.setText(Gui.this.getText("ui.select"));
                this.selectLogo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Gui.this.getFileToRes(Gui.this.imageFiles, logoName, (Component)Gui.this.skinUi);
                    }
                });
                this.showBreadcrumbPath.setToolTipText(Gui.this.getText("ui.showBreadcrumbPathInfo"));
                Gui.this.allowHTMLEditing(this.header);
                this.header.setEditable(true);
                this.header.setLineWrap(true);
                this.header.setWrapStyleWord(true);
                this.header.setFont(Gui.this.mono);
                this.header.setTabSize(2);
                this.header.setToolTipText(Gui.this.getText("ui.customContentInfo"));
                this.headerPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.customContent") + ": " + Gui.this.getText("ui.addedAtCoverPageTop")));
                this.add("", new JLabel(Gui.this.getText("ui.logo")));
                this.add("tab", this.logoName);
                this.add("", this.selectLogo);
                this.add("br hfill", (Component)this.topMenu);
                this.add("br", this.showBreadcrumbPath);
                this.add("br hfill vfill", this.headerPane);
            }
        };
        ControlPanel coverTitle = new ControlPanel(){
            JComboBox<NameValue<String>> presets;
            JTextArea titleCaptionTemplate;
            JScrollPane captionPane;
            JComboBox folderDateSource;
            JTextField folderImageSize;
            {
                this.presets = new JComboBox<NameValue>(new NameValue[]{new NameValue(Gui.this.getText("ui.empty"), (Object)""), new NameValue(Gui.this.getText("ui.title"), (Object)"<h1>${title}</h1>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.description"), (Object)"<h1>${title}</h1>\n<div class=\"description\">${description}</div>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.date") + " + " + Gui.this.getText("ui.description") + " (" + Gui.this.getText("ui.default") + ")", (Object)"<h1>${title} <span class=\"date\">${folderModDate}</span></h1>\n<div class=\"description\">${description}</div>")});
                this.titleCaptionTemplate = new JSmartTextArea(4, 20);
                this.captionPane = new JScrollPane(this.titleCaptionTemplate);
                this.folderDateSource = new JComboBox<Object>(new Object[]{new Item((Object)"none", (Object)Gui.this.getText("ui.none")), new Item((Object)"fileDate", (Object)Gui.this.getText("ui.fileDate")), new Item((Object)"folderModDate", (Object)Gui.this.getText("ui.folderModDate")), new Item((Object)"lastCameraDate", (Object)Gui.this.getText("ui.lastCameraDate")), new Item((Object)"cameraDateRange", (Object)Gui.this.getText("ui.cameraDateRange"))});
                this.folderImageSize = new JTextField("1800x800");
                heroType.addActionListener(e -> this.setFolderImageSize());
                this.folderImageSize.setEnabled(false);
                this.titleCaptionTemplate.setEditable(true);
                this.titleCaptionTemplate.setLineWrap(true);
                this.titleCaptionTemplate.setWrapStyleWord(true);
                this.titleCaptionTemplate.setFont(Gui.this.mono);
                this.titleCaptionTemplate.setTabSize(2);
                this.captionPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.captionTemplate")));
                this.presets.addItemListener(listener -> this.titleCaptionTemplate.setText((String)((NameValue)this.presets.getSelectedItem()).value));
                this.add("", new JLabel(Gui.this.getText("ui.type")));
                this.add("tab", heroType);
                this.add("tab", this.folderImageSize);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.presets"), this.presets));
                this.add("tab", this.presets);
                this.add("br hfill", this.captionPane);
                this.add("br", (Component)new JLabelFor("${folderModDate} =", (JComponent)this.folderDateSource));
                this.add("tab", this.folderDateSource);
            }

            private void setFolderImageSize() {
                if (!Gui.this.isSkinReady()) {
                    return;
                }
                int i = heroType.getSelectedIndex();
                if (i == 0) {
                    this.folderImageSize.setText("1800x800");
                } else if (i == 1) {
                    this.folderImageSize.setText("1000x600");
                } else {
                    this.folderImageSize.setText("320x320");
                }
            }
        };
        ControlPanel folders = new ControlPanel(){
            JComboBox<NameValue<String>> presets;
            JTextArea folderCaptionTemplate;
            JScrollPane captionPane;
            JCheckBox showFolderImageCount;
            JCheckBox gatherWeblocationInfo;
            JCheckBox webLocationOpenNew;
            {
                this.presets = new JComboBox<NameValue>(new NameValue[]{new NameValue(Gui.this.getText("ui.empty"), (Object)""), new NameValue(Gui.this.getText("ui.title"), (Object)"<h3>${title}</h3>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.comment"), (Object)"<h3>${title}</h3>\n<div class=\"comment\">${comment}</div>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.commentShort") + " (" + Gui.this.getText("ui.default") + ")", (Object)"<h3>${title}</h3>\n<div class=\"comment\">${commentShort}</div>"), new NameValue(Gui.this.getText("ui.fileLabel"), (Object)"<h3>${fileLabel}</h3>"), new NameValue(Gui.this.getText("ui.fileLabel") + " + " + Gui.this.getText("ui.comment"), (Object)"<h3>${fileLabel}</h3>\n<div class=\"comment\">${comment}</div>")});
                this.folderCaptionTemplate = new JSmartTextArea(4, 30);
                this.captionPane = new JScrollPane(this.folderCaptionTemplate);
                this.showFolderImageCount = new JCheckBox(Gui.this.getText("ui.showFolderImageCount"), true);
                this.gatherWeblocationInfo = new JCheckBox(Gui.this.getText("ui.gatherWeblocationInfo"), true);
                this.webLocationOpenNew = new JCheckBox(Gui.this.getText("ui.webLocationsOpenInNewWindow"));
                this.presets.addItemListener(listener -> {
                    if (!Gui.this.isSkinReady()) {
                        return;
                    }
                    this.folderCaptionTemplate.setText((String)((NameValue)this.presets.getSelectedItem()).value);
                });
                this.folderCaptionTemplate.setEditable(true);
                this.folderCaptionTemplate.setLineWrap(true);
                this.folderCaptionTemplate.setWrapStyleWord(true);
                this.folderCaptionTemplate.setFont(Gui.this.mono);
                this.folderCaptionTemplate.setTabSize(2);
                this.captionPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.captionTemplate")));
                this.showFolderImageCount.setToolTipText(Gui.this.getText("ui.showFolderImageCountInfo"));
                this.gatherWeblocationInfo.setToolTipText(Gui.this.getText("ui.gatherWeblocationInfoInfo"));
                this.add(new JLabel(Gui.this.getText("ui.type")));
                this.add("tab", folderThumbType);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.presets"), this.presets));
                this.add("tab", this.presets);
                this.add("br hfill", this.captionPane);
                this.add("br", this.showFolderImageCount);
                this.add("br", this.gatherWeblocationInfo);
                this.add("br", this.webLocationOpenNew);
            }
        };
        ControlPanel footerTab = new ControlPanel(){
            JCheckBox showModifiedDate;
            JCheckBox showImageCount;
            JSmartTextArea footer;
            JScrollPane footerPane;
            ControlPanel customLinkPanel;
            {
                this.showModifiedDate = new JCheckBox(Gui.this.getText("ui.showModifiedDate"));
                this.showImageCount = new JCheckBox(Gui.this.getText("ui.showFolderImageCount"));
                this.footer = new JSmartTextArea(8, 20);
                this.footerPane = new JScrollPane((Component)this.footer);
                this.customLinkPanel = new ControlPanel(Gui.this.getText("ui.customLink")){
                    JTextField customLink;
                    JTextField customLinkText;
                    {
                        this.customLink = new JSmartTextField(16);
                        this.customLinkText = new JSmartTextField(16);
                        this.customLink.setToolTipText(Gui.this.getText("ui.customLinkInfo"));
                        this.customLinkText.setToolTipText(Gui.this.getText("ui.customLinkTextInfo"));
                        Gui.this.allowHTMLEditing(footer);
                        this.add(new JLabel("URL"));
                        this.add("tab hfill", this.customLink);
                        this.add("br", new JLabel(Gui.this.getText("ui.customLinkText")));
                        this.add("tab hfill", this.customLinkText);
                    }
                };
                this.showImageCount.setToolTipText(Gui.this.getText("ui.showFolderImageCountInfo"));
                this.footer.setEditable(true);
                this.footer.setLineWrap(true);
                this.footer.setWrapStyleWord(true);
                this.footer.setFont(Gui.this.mono);
                this.footer.setTabSize(2);
                this.footer.setToolTipText(Gui.this.getText("ui.customContentInfo"));
                this.footerPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.customFooterText")));
                this.add("", this.showModifiedDate);
                this.add("br", this.showImageCount);
                this.add("br hfill", (Component)this.customLinkPanel);
                this.add("br hfill vfill", this.footerPane);
            }
        };
        ControlPanel topNavigation = new ControlPanel(){
            JComboBox topNavigationDisplay;
            JCheckBox topNavigationIncludeFolders;
            JCheckBox topNavigationIncludePages;
            JCheckBox topNavigationIncludeWebLocations;
            JSpinner topNavigationDepth;
            {
                this.topNavigationDisplay = new JComboBox<Object>(new Object[]{new Item((Object)"button", (Object)Gui.this.getText("ui.onlyButton")), new Item((Object)"auto", (Object)Gui.this.getText("ui.dependsOnWindowSize")), new Item((Object)"always", (Object)Gui.this.getText("ui.alwaysShow"))});
                this.topNavigationIncludeFolders = new JCheckBox(Gui.this.getText("ui.includeFolders"), true);
                this.topNavigationIncludePages = new JCheckBox(Gui.this.getText("ui.includePages"));
                this.topNavigationIncludeWebLocations = new JCheckBox(Gui.this.getText("ui.includeWebLocations"));
                this.topNavigationDepth = new JSpinner(new SpinnerNumberModel(4, 1, 6, 1));
                this.add((Component)new JLabelFor(Gui.this.getText("ui.folderTreeVisibility"), (JComponent)this.topNavigationDisplay));
                this.add(" ", this.topNavigationDisplay);
                this.add("br", this.topNavigationIncludeFolders);
                this.add("br", this.topNavigationIncludePages);
                this.add("br", this.topNavigationIncludeWebLocations);
                this.add("br", new JLabel(Gui.this.getText("ui.depth")));
                this.add("", this.topNavigationDepth);
                this.add("", new JLabel(Gui.this.getText("ui.levels")));
            }
        };
        ControlPanel search = new ControlPanel(){
            JCheckBox useSearch;
            JTextField searchFields;
            JLabel fieldsInfo;
            {
                this.useSearch = new JCheckBox(Gui.this.getText("ui.useSearch"));
                this.searchFields = new JSmartTextField(16);
                this.fieldsInfo = new JLabel("<html><i>" + Gui.this.getText("ui.searchFieldsInfo") + "</i></html>");
                ComponentUtilities.whenSelectedEnable((AbstractButton)this.useSearch, (JComponent[])new JComponent[]{this.searchFields, this.fieldsInfo});
                this.add("", this.useSearch);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.fields"), (JComponent)this.searchFields));
                this.add("tab hfill", this.searchFields);
                this.add("br", new JLabel(""));
                this.add("tab", this.fieldsInfo);
            }
        };
        ControlPanel tagCloud = new ControlPanel(){
            JComboBox tagCloudSource;
            JCheckBox tagCloudUseFolders;
            JCheckBox tagCloudUsePages;
            JCheckBox tagCloudUseWebLocations;
            JLabel tagCloudSkipLevelsLabel;
            JSpinner tagCloudSkipLevels;
            JTextField tagCloudLabel;
            JTextField tagCloudFields;
            JComboBox tagCloudSort;
            JCheckBox tagCloudFontVaries;
            JCheckBox tagCloudSearch;
            {
                this.tagCloudSource = new JComboBox<Object>(new Object[]{new Item((Object)"none", (Object)Gui.this.getText("ui.noTagCloud")), new Item((Object)"current", (Object)Gui.this.getText("ui.currentFolder")), new Item((Object)"subfolders", (Object)Gui.this.getText("ui.subfolders")), new Item((Object)"tree", (Object)Gui.this.getText("ui.wholeAlbum"))});
                this.tagCloudUseFolders = new JCheckBox(Gui.this.getText("ui.folders"), true);
                this.tagCloudUsePages = new JCheckBox(Gui.this.getText("ui.pages"));
                this.tagCloudUseWebLocations = new JCheckBox(Gui.this.getText("ui.webLocations"));
                this.tagCloudSkipLevelsLabel = new JLabel(Gui.this.getText("ui.skipLevels"));
                this.tagCloudSkipLevels = new JSpinner(new SpinnerNumberModel(1, 0, 5, 1));
                this.tagCloudLabel = new JSmartTextField(12);
                this.tagCloudFields = new JSmartTextField(16);
                this.tagCloudSort = new JComboBox<Object>(new Object[]{new Item((Object)"none", (Object)Gui.this.getText("ui.unsorted")), new Item((Object)"name", (Object)Gui.this.getText("ui.name")), new Item((Object)"frequency", (Object)Gui.this.getText("ui.frequency"))});
                this.tagCloudFontVaries = new JCheckBox(Gui.this.getText("ui.tagCloudFontVaries"));
                this.tagCloudSearch = new JCheckBox(Gui.this.getText("ui.addSearchBox"));
                this.tagCloudLabel.setText(Gui.this.getText("ui.labels"));
                this.tagCloudSource.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int tsi = tagCloudSource.getSelectedIndex();
                        tagCloudUseFolders.setEnabled(tsi > 0);
                        tagCloudUsePages.setEnabled(tsi > 0);
                        tagCloudUseWebLocations.setEnabled(tsi > 0);
                        tagCloudLabel.setEnabled(tsi > 0);
                        tagCloudFields.setEnabled(tsi > 0);
                        tagCloudSort.setEnabled(tsi > 0);
                        tagCloudFontVaries.setEnabled(tsi > 0);
                        tagCloudSearch.setEnabled(tsi > 0);
                        tagCloudSkipLevels.setVisible(tsi == 2);
                        tagCloudSkipLevelsLabel.setVisible(tsi == 2);
                    }
                });
                this.tagCloudSkipLevels.setToolTipText(Gui.this.getText("ui.skipLevelsInfo"));
                this.tagCloudFields.setToolTipText("<html>" + Gui.this.getText("ui.searchFieldsInfo") + "</html>");
                this.tagCloudFontVaries.setToolTipText(Gui.this.getText("ui.tagCloudFontVariesInfo"));
                this.add((Component)new JLabelFor(Gui.this.getText("ui.collectFrom"), (JComponent)this.tagCloudSource));
                this.add("tab", this.tagCloudSource);
                this.add("tab", this.tagCloudSkipLevelsLabel);
                this.add("", this.tagCloudSkipLevels);
                this.add("", this.tagCloudUseFolders);
                this.add("", this.tagCloudUsePages);
                this.add("", this.tagCloudUseWebLocations);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.boxTitle"), (JComponent)this.tagCloudLabel));
                this.add("tab hfill", this.tagCloudLabel);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.fields"), (JComponent)this.tagCloudFields));
                this.add("tab hfill", this.tagCloudFields);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.sortBy"), (JComponent)this.tagCloudSort));
                this.add("tab", this.tagCloudSort);
                this.add("tab", this.tagCloudFontVaries);
                this.add("br tab", this.tagCloudSearch);
            }
        };
        ControlPanel searchNew = new ControlPanel(){
            JComboBox searchNewSource;
            JTextField searchNewDays;
            JComboBox searchNewReference;
            JCheckBox searchNewSinceLastVisit;
            {
                this.searchNewSource = new JComboBox<Object>(new Object[]{new Item((Object)"none", (Object)Gui.this.getText("ui.noSearchNew")), new Item((Object)"current", (Object)Gui.this.getText("ui.currentFolder")), new Item((Object)"subfolders", (Object)Gui.this.getText("ui.subfolders")), new Item((Object)"tree", (Object)Gui.this.getText("ui.wholeAlbum"))});
                this.searchNewDays = new JSmartTextField(12);
                this.searchNewReference = new JComboBox<Object>(new Object[]{new Item((Object)"dateTaken", (Object)Gui.this.getText("ui.dateTaken")), new Item((Object)"fileModified", (Object)Gui.this.getText("ui.fileModified")), new Item((Object)"added", (Object)Gui.this.getText("ui.addedToAlbum"))});
                this.searchNewSinceLastVisit = new JCheckBox(Gui.this.getText("ui.searchNewSinceLastVisit"));
                this.searchNewSource.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean on = searchNewSource.getSelectedIndex() > 0;
                        searchNewDays.setEnabled(on);
                        searchNewReference.setEnabled(on);
                        searchNewSinceLastVisit.setEnabled(on);
                    }
                });
                this.searchNewDays.setToolTipText(Gui.this.getText("ui.searchNewDaysInfo"));
                this.searchNewSinceLastVisit.setToolTipText(Gui.this.getText("ui.searchNewSinceLastVisitInfo"));
                this.add((Component)new JLabelFor(Gui.this.getText("ui.collectFrom"), (JComponent)this.searchNewSource));
                this.add("tab", this.searchNewSource);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.days"), (JComponent)this.searchNewDays));
                this.add("tab hfill", this.searchNewDays);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.reference"), (JComponent)this.searchNewReference));
                this.add("tab", this.searchNewReference);
                this.add("br tab", this.searchNewSinceLastVisit);
                this.putClientProperty("helpPage", Gui.this.helpRoot + "Sections/Search_new_images");
            }
        };
        ControlPanel map = new ControlPanel(){
            JCheckBox showMapSection;
            JComboBox mapType;
            JSlider mapZoom;
            JTextField googleApiKey;
            JLabel mandatoryInfo;
            {
                this.showMapSection = new JCheckBox(Gui.this.getText("ui.showMap"), true);
                this.mapType = new JComboBox<Object>(new Object[]{new Item((Object)"roadmap", (Object)Gui.this.getText("ui.roadmap")), new Item((Object)"satellite", (Object)Gui.this.getText("ui.satellite")), new Item((Object)"hybrid", (Object)Gui.this.getText("ui.hybrid")), new Item((Object)"terrain", (Object)Gui.this.getText("ui.terrain"))});
                this.mapZoom = new JSlider(0, 1, 20, 18);
                this.googleApiKey = new JSmartTextField(32);
                this.mandatoryInfo = new JLabel(mandatory);
                this.showMapSection.setToolTipText(Gui.this.getText("ui.showMapSectionInfo"));
                this.mapZoom.setOrientation(0);
                this.mapZoom.setMinimum(0);
                this.mapZoom.setMaximum(20);
                this.mapZoom.setValue(18);
                this.mapZoom.setMajorTickSpacing(10);
                this.mapZoom.setMinorTickSpacing(1);
                this.mapZoom.setPaintTicks(true);
                this.mapZoom.setPaintLabels(true);
                this.mapZoom.setSnapToTicks(true);
                this.mandatoryInfo.setToolTipText(Gui.this.getText("ui.mandatory"));
                this.add(this.showMapSection);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.initialView"), (JComponent)this.mapType));
                this.add("tab", this.mapType);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.initialZoom"), (JComponent)this.mapZoom));
                this.add("tab", this.mapZoom);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.googleApiKey"), (JComponent)this.googleApiKey));
                this.add(this.mandatoryInfo);
                this.add("tab", this.googleApiKey);
                this.add("br tab", (Component)new JLinkLabel("https://console.developers.google.com/apis/credentials", Gui.this.getText("ui.createNew")));
                this.add("br tab", new JLabel("<html><i>" + Gui.this.getText("ui.googleApiKeyInfo") + "</i></html>"));
                this.add("br tab", (Component)new JLinkLabel("https://developers.google.com/maps/documentation/javascript/tutorial", Gui.this.getText("ui.readMore")));
            }
        };
        ControlPanel social = new ControlPanel(){
            ControlPanel shares;
            ControlPanel links;
            JTextField facebookAppId;
            JLabel mandatoryInfo;
            {
                this.shares = new ControlPanel(Gui.this.getText("ui.shareButtonFor")){
                    JCheckBox shareTwitter;
                    JCheckBox sharePinterest;
                    JCheckBox shareLinkedin;
                    JCheckBox shareDigg;
                    JCheckBox shareReddit;
                    JCheckBox shareTumblr;
                    {
                        this.shareTwitter = new JCheckBox("X");
                        this.sharePinterest = new JCheckBox("Pinterest");
                        this.shareLinkedin = new JCheckBox("LinkedIn");
                        this.shareDigg = new JCheckBox("Digg");
                        this.shareReddit = new JCheckBox("Reddit");
                        this.shareTumblr = new JCheckBox("Tumblr");
                        this.setLayout((LayoutManager)new RiverLayout(4, 5));
                        this.add(new JLabel(Gui.icon("facebook")));
                        this.add(shareFacebook);
                        this.add("br", new JLabel(Gui.icon("threads")));
                        this.add(shareThreads);
                        this.add("br", new JLabel(Gui.icon("bluesky")));
                        this.add(shareBluesky);
                        this.add("br", new JLabel(Gui.icon("x")));
                        this.add(this.shareTwitter);
                        this.add("br", new JLabel(Gui.icon("reddit")));
                        this.add(this.shareReddit);
                        this.add("br", new JLabel(Gui.icon("pinterest")));
                        this.add(this.sharePinterest);
                        this.add("br", new JLabel(Gui.icon("tumblr")));
                        this.add(this.shareTumblr);
                        this.add("br", new JLabel(Gui.icon("linkedin")));
                        this.add(this.shareLinkedin);
                        this.add("br", new JLabel(Gui.icon("digg")));
                        this.add(this.shareDigg);
                    }
                };
                this.links = new ControlPanel(){
                    JCheckBox shareEmail = new JCheckBox("Email");
                    JLabel emailSubjectLabel;
                    JTextField emailSubject;
                    JTextArea emailBody;
                    JScrollPane emailBodyPane;
                    JCheckBox shareLink;
                    {
                        this.emailSubjectLabel = new JLabel(Gui.this.getText("ui.subject"));
                        this.emailSubject = new JSmartTextField(18);
                        this.emailBody = new JSmartTextArea(4, 20);
                        this.emailBodyPane = new JScrollPane(this.emailBody);
                        this.shareLink = new JCheckBox(Gui.this.getText("ui.link"));
                        this.emailBody.setEditable(true);
                        this.emailBody.setLineWrap(true);
                        this.emailBody.setWrapStyleWord(true);
                        this.emailBody.setToolTipText(Gui.this.getText("ui.emailBodyInfo"));
                        this.emailBodyPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.body")));
                        ComponentUtilities.whenSelectedEnable((AbstractButton)this.shareEmail, (JComponent[])new JComponent[]{this.emailSubjectLabel, this.emailSubject, this.emailBodyPane});
                        this.add("", new JLabel(Gui.icon("email")));
                        this.add("tab", this.shareEmail);
                        this.add("br tab", this.emailSubjectLabel);
                        this.add("", this.emailSubject);
                        this.add("br tab", this.emailBodyPane);
                        this.add("br", new JLabel(Gui.icon("link")));
                        this.add("tab", this.shareLink);
                    }
                };
                this.facebookAppId = new JSmartTextField("");
                this.mandatoryInfo = new JLabel(mandatory);
                this.mandatoryInfo.setToolTipText(Gui.this.getText("ui.mandatory"));
                this.links.setBorder(Gui.this.emptyBorder);
                this.add("", (Component)this.shares);
                this.add("hfill", (Component)this.links);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.facebookAppId"), (JComponent)this.facebookAppId));
                this.add(this.mandatoryInfo);
                this.add("tab hfill", this.facebookAppId);
                this.add((Component)new JLinkLabel("https://developers.facebook.com/apps", Gui.this.getText("ui.signUp")));
            }
        };
        ControlPanel fullScreen = new ControlPanel(){
            JCheckBox showFullscreen;
            {
                this.showFullscreen = new JCheckBox(Gui.this.getText("ui.showFullScreenButton"), false);
                this.add(this.showFullscreen);
            }
        };
        ControlPanel backgroundMusic = new ControlPanel(){
            JPlaylist backgroundAudio = new JPlaylist();
            JCheckBox backgroundAudioAutoPlay;
            JSpinner backgroundAudioVolume;
            JCheckBox backgroundAudioSlideshowControl;
            JCheckBox muteBackgroundAudio;
            JCheckBox backgroundAudioLoop;
            JCheckBox backgroundAudioRetainPosition;
            WrappableJLabel autostartNotice;
            {
                this.backgroundAudioAutoPlay = new JCheckBox(Gui.this.getText("ui.autoStart"));
                this.backgroundAudioVolume = new JSpinner(new SpinnerNumberModel(25, 1, 100, 1));
                this.backgroundAudioSlideshowControl = new JCheckBox(Gui.this.getText("ui.slideshowControl"));
                this.muteBackgroundAudio = new JCheckBox(Gui.this.getText("ui.muteBackgroundAudio"), true);
                this.backgroundAudioLoop = new JCheckBox(Gui.this.getText("ui.loop"));
                this.backgroundAudioRetainPosition = new JCheckBox(Gui.this.getText("ui.retainPosition"), true);
                this.autostartNotice = new WrappableJLabel("<html><i>" + Gui.this.getText("ui.autostartNotice") + "</i></html>");
                this.backgroundAudioSlideshowControl.setToolTipText(Gui.this.getText("ui.slideshowControlInfo"));
                this.muteBackgroundAudio.setToolTipText(Gui.this.getText("ui.muteBackgroundAudioInfo"));
                this.backgroundAudioRetainPosition.setToolTipText(Gui.this.getText("ui.retainPositionInfo"));
                this.autostartNotice.setPreferredWidth(340);
                this.add("br hfill", (Component)this.backgroundAudio);
                this.add("br", new JLabel(Gui.this.getText("ui.initialVolume")));
                this.add("", this.backgroundAudioVolume);
                this.add("", new JLabel("%"));
                this.add("br", this.backgroundAudioAutoPlay);
                this.add("tab", this.backgroundAudioLoop);
                this.add("br", this.backgroundAudioRetainPosition);
                this.add("br", this.backgroundAudioSlideshowControl);
                this.add("br", this.muteBackgroundAudio);
                this.add("br", new JLabel(infoIcon));
                this.add("", (Component)this.autostartNotice);
            }
        };
        ControlPanel thumbnailStrip = new ControlPanel(){
            JComboBox thumbstripVisibility;
            JComboBox thumbstripPosition;
            JCheckBox fixedShapeThumbs;
            JTextArea thumbCaptionTemplate;
            JComboBox<NameValue<String>> presets;
            JScrollPane captionPane;
            {
                this.thumbstripVisibility = new JComboBox<Object>(new Object[]{new Item((Object)"hidden", (Object)Gui.this.getText("ui.alwaysHidden")), new Item((Object)"auto", (Object)Gui.this.getText("ui.hiddenDuringSlideshow")), new Item((Object)"visible", (Object)Gui.this.getText("ui.alwaysVisible"))});
                this.thumbstripPosition = new JComboBox<Object>(new Object[]{new Item((Object)"top", (Object)Gui.this.getText("ui.top")), new Item((Object)"right", (Object)Gui.this.getText("ui.right")), new Item((Object)"bottom", (Object)Gui.this.getText("ui.bottom")), new Item((Object)"left", (Object)Gui.this.getText("ui.left"))});
                this.fixedShapeThumbs = new JCheckBox(Gui.this.getText("ui.fixedShapeThumbs"), false);
                this.thumbCaptionTemplate = new JSmartTextArea(4, 30);
                this.presets = new JComboBox<NameValue>(new NameValue[]{new NameValue(Gui.this.getText("ui.empty"), (Object)""), new NameValue(Gui.this.getText("ui.title"), (Object)"<h6>${fileTitle}</h6>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.comment"), (Object)"<h6>${fileTitle}</h6>\n<div class=\"comment\">${comment}</div>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.commentShort") + " (" + Gui.this.getText("ui.default") + ")", (Object)"<h6>${fileTitle}</h6>\n<div class=\"comment\">${commentShort}</div>"), new NameValue(Gui.this.getText("ui.number") + " + " + Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.commentShort"), (Object)"<span class=\"nr\">${imageNum}</span>\n<h6>${fileTitle}</h6>\n<div class=\"comment\">${commentShort}</div>"), new NameValue(Gui.this.getText("ui.fileLabel"), (Object)"<h6>${fileLabel}</h6>"), new NameValue(Gui.this.getText("ui.fileLabel") + " + " + Gui.this.getText("ui.comment"), (Object)"<h6>${fileLabel}</h6>\n<div class=\"comment\">${comment}</div>"), new NameValue(Gui.this.getText("ui.fileLabel") + " + " + Gui.this.getText("ui.commentShort"), (Object)"<h6>${fileLabel}</h6>\n<div class=\"comment\">${commentShort}</div>"), new NameValue(Gui.this.getText("ui.number") + " + " + Gui.this.getText("ui.fileLabel") + " + " + Gui.this.getText("ui.commentShort"), (Object)"<span class=\"nr\">${imageNum}</span>\n<h6>${fileLabel}</h6>\n<div class=\"comment\">${commentShort}</div>")});
                this.captionPane = new JScrollPane(this.thumbCaptionTemplate);
                this.fixedShapeThumbs.setToolTipText(Gui.this.getText("ui.fixedShapeThumbsInfo"));
                this.presets.addItemListener(listener -> {
                    if (!Gui.this.isSkinReady()) {
                        return;
                    }
                    this.thumbCaptionTemplate.setText((String)((NameValue)this.presets.getSelectedItem()).value);
                });
                this.captionPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.captionTemplate")));
                this.thumbCaptionTemplate.setEditable(true);
                this.thumbCaptionTemplate.setLineWrap(true);
                this.thumbCaptionTemplate.setWrapStyleWord(true);
                this.thumbCaptionTemplate.setFont(Gui.this.mono);
                this.thumbCaptionTemplate.setTabSize(2);
                this.add(new JLabel(Gui.this.getText("ui.thumbstripVisibility")));
                this.add("tab", this.thumbstripVisibility);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.thumbstripPosition"), (JComponent)this.thumbstripPosition));
                this.add("tab", this.thumbstripPosition);
                this.add("br", this.fixedShapeThumbs);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.presets"), this.presets));
                this.add("tab", this.presets);
                this.add("br hfill", this.captionPane);
            }
        };
        ControlPanel markNew = new ControlPanel(){
            JCheckBox markFilesNew;
            JTextField newDaysCount;
            JComboBox newDaysRef;
            JComboBox newDaysMark;
            JTextField newDaysText;
            JLabel newIcon;
            {
                this.markFilesNew = new JCheckBox(Gui.this.getText("ui.markFilesNew"));
                this.newDaysCount = new JSmartTextField("60", 3);
                this.newDaysRef = new JComboBox<Object>(new Object[]{new Item((Object)"dateTaken", (Object)Gui.this.getText("ui.dateTaken")), new Item((Object)"fileModified", (Object)Gui.this.getText("ui.fileModified")), new Item((Object)"added", (Object)Gui.this.getText("ui.addedToAlbum"))});
                this.newDaysMark = new JComboBox<Object>(new Object[]{new Item((Object)"icon", (Object)Gui.this.getText("ui.icon")), new Item((Object)"text", (Object)Gui.this.getText("ui.text"))});
                this.newDaysText = new JSmartTextField(Gui.this.getText("new"), 6);
                this.newIcon = new JLabel(Gui.icon("new-fill"));
                this.newDaysCount.setToolTipText(Gui.this.getText("ui.newDaysCountInfo"));
                this.newDaysMark.addItemListener(listener -> {
                    int i = this.newDaysMark.getSelectedIndex();
                    this.newDaysText.setVisible(i == 1);
                    this.newIcon.setVisible(i == 0);
                });
                this.newDaysText.setVisible(false);
                ComponentUtilities.whenSelectedEnable((AbstractButton)this.markFilesNew, (JComponent[])new JComponent[]{this.newDaysCount, this.newDaysRef, this.newDaysMark, this.newDaysText, this.newIcon});
                this.add("", this.markFilesNew);
                this.add("", this.newDaysCount);
                this.add(new JLabel(Gui.this.getText("ui.daysOld")));
                this.add("br", new JLabel(Gui.this.getText("ui.reference")));
                this.add(this.newDaysRef);
                this.add("br", new JLabel(Gui.this.getText("ui.marker")));
                this.add("tab", this.newDaysMark);
                this.add(this.newIcon);
                this.add(this.newDaysText);
            }
        };
        ControlPanel mainImage = new ControlPanel(){
            JCheckBox useFullScreen;
            JCheckBox videoAutoPlay;
            JLabel videoAutoPlayInfo;
            JCheckBox hideSidebarDuringSlideshow;
            JComboBox<Item> transitionType;
            JSpinner transitionSpeed;
            JSpinner slideshowDelay;
            JCheckBox slideshowAuto;
            JComboBox afterLast;
            JCheckBox neighboringFolderSkipLevels;
            JCheckBox neighboringFolderLoop;
            JComboBox fitImages;
            JCheckBox neverScaleUp;
            JSpinner fitPadding;
            JCheckBox panoramaPlayer;
            JCheckBox panoramaPlayerAuto;
            JCheckBox rightClickProtect;
            ControlPanel behaviorPanel;
            ControlPanel mainImagePanel;
            ControlPanel navigation;
            {
                this.useFullScreen = new JCheckBox(Gui.this.getText("ui.fullscreenOnMobiles"));
                this.videoAutoPlay = new JCheckBox(Gui.this.getText("ui.startVideo"));
                this.videoAutoPlayInfo = new JLabel(infoIcon);
                this.hideSidebarDuringSlideshow = new JCheckBox(Gui.this.getText("ui.hideSidebarDuringSlideshow"));
                this.transitionType = new JComboBox<Object>(new Object[]{new Item((Object)"crossfade", (Object)Gui.this.getText("ui.crossFade")), new Item((Object)"zoom", (Object)Gui.this.getText("ui.zoom")), new Item((Object)"kenburns", (Object)Gui.this.getText("ui.kenBurns")), new Item((Object)"stack", (Object)Gui.this.getText("ui.stack")), new Item((Object)"slide", (Object)Gui.this.getText("ui.slide")), new Item((Object)"swap", (Object)Gui.this.getText("ui.swap")), new Item((Object)"flip", (Object)Gui.this.getText("ui.flip")), new Item((Object)"book", (Object)Gui.this.getText("ui.book")), new Item((Object)"cube", (Object)Gui.this.getText("ui.cube"))});
                this.transitionSpeed = new JSpinner(new SpinnerNumberModel(1000, 50, 10000, 50));
                this.slideshowDelay = new JSpinner(new SpinnerNumberModel(3000, 0, 20000, 50));
                this.slideshowAuto = new JCheckBox(Gui.this.getText("ui.autoStartSlideshow"));
                this.afterLast = new JComboBox<Object>(new Object[]{new Item((Object)"donothing", (Object)Gui.this.getText("ui.doNothing")), new Item((Object)"startover", (Object)Gui.this.getText("startOver")), new Item((Object)"onelevelup", (Object)Gui.this.getText("upOneLevel")), new Item((Object)"backtocover", (Object)Gui.this.getText("backToCover")), new Item((Object)"nextfolder", (Object)Gui.this.getText("nextFoldersFirstImage")), new Item((Object)"ask", (Object)Gui.this.getText("ui.ask"))});
                this.neighboringFolderSkipLevels = new JCheckBox(Gui.this.getText("ui.skipFolderLevels"), false);
                this.neighboringFolderLoop = new JCheckBox(Gui.this.getText("ui.neighboringFolderLoop"), false);
                this.fitImages = new JComboBox<Object>(new Object[]{new Item((Object)"no", (Object)Gui.this.getText("ui.originalSize")), new Item((Object)"vertically", (Object)Gui.this.getText("ui.fitVertically")), new Item((Object)"both", (Object)Gui.this.getText("ui.fitBoth")), new Item((Object)"cover", (Object)Gui.this.getText("ui.cover"))});
                this.neverScaleUp = new JCheckBox(Gui.this.getText("ui.neverScaleUp"));
                this.fitPadding = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));
                this.panoramaPlayer = new JCheckBox(Gui.this.getText("ui.panoramaPlayer"), false);
                this.panoramaPlayerAuto = new JCheckBox(Gui.this.getText("ui.autoStart"), true);
                this.rightClickProtect = new JCheckBox(Gui.this.getText("ui.rightClickProtect"));
                this.behaviorPanel = new ControlPanel(Gui.this.getText("ui.behavior")){
                    {
                        useFullScreen.setToolTipText(Gui.this.getText("ui.fullscreenOnMobilesInfo"));
                        afterLast.setToolTipText(Gui.this.getText("ui.afterLastInfo"));
                        videoAutoPlayInfo.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseReleased(MouseEvent e) {
                                JOptionPane.showMessageDialog((Component)Gui.this.window, Gui.this.getText("ui.videoAutoplayInfo1"), "Warning", 2);
                            }
                        });
                        neighboringFolderSkipLevels.setToolTipText(Gui.this.getText("ui.skipFolderLevelsInfo"));
                        neighboringFolderLoop.setToolTipText(Gui.this.getText("ui.neighboringFolderLoopInfo"));
                        transitionSpeed.setToolTipText(Gui.this.getText("ui.transitionSpeedInfo"));
                        slideshowDelay.setToolTipText(Gui.this.getText("ui.slideshowDelayInfo"));
                        this.add("", slideshowAuto);
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.transition"), transitionType));
                        this.add("tab", transitionType);
                        this.add("tab", (Component)new JLabelFor(Gui.this.getText("ui.transitionSpeed"), (JComponent)transitionSpeed));
                        this.add(transitionSpeed);
                        this.add(new JLabel("ms"));
                        this.add("br", new JLabel(Gui.this.getText("ui.slideshowDelay")));
                        this.add("tab", slideshowDelay);
                        this.add(new JLabel("ms"));
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.afterLast"), (JComponent)afterLast));
                        this.add("tab", afterLast);
                        this.add("br", neighboringFolderSkipLevels);
                        this.add("tab", neighboringFolderLoop);
                        this.add("br", useFullScreen);
                        this.add("br", hideSidebarDuringSlideshow);
                        this.add("br", videoAutoPlay);
                        this.add("", videoAutoPlayInfo);
                    }
                };
                this.mainImagePanel = new ControlPanel(Gui.this.getText("ui.images")){
                    {
                        fitImages.setToolTipText(Gui.this.getText("ui.fitImagesInfo"));
                        neverScaleUp.setToolTipText(Gui.this.getText("ui.neverScaleUpInfo"));
                        ComponentUtilities.whenSelectedEnable((AbstractButton)panoramaPlayer, (JComponent[])new JComponent[]{panoramaPlayerAuto});
                        rightClickProtect.setToolTipText(Gui.this.getText("ui.rightClickProtectInfo"));
                        this.add((Component)new JLabelFor(Gui.this.getText("ui.scaling"), (JComponent)fitImages));
                        this.add("", fitImages);
                        this.add(" ", (Component)new JLabelFor(Gui.this.getText("ui.padding"), (JComponent)fitPadding));
                        this.add("", fitPadding);
                        this.add(new JLabel("px"));
                        this.add("br", neverScaleUp);
                        this.add("br", rightClickProtect);
                    }
                };
                this.navigation = new ControlPanel(Gui.this.getText("ui.navigation")){
                    JCheckBox enableMouseWheel;
                    JCheckBox enableKeyboard;
                    JComboBox clickAction;
                    {
                        this.enableMouseWheel = new JCheckBox(Gui.this.getText("ui.enableMouseWheel"), true);
                        this.enableKeyboard = new JCheckBox(Gui.this.getText("ui.enableKeyboard"), true);
                        this.clickAction = new JComboBox<Object>(new Object[]{new Item((Object)"donothing", (Object)Gui.this.getText("ui.doNothing")), new Item((Object)"nextimage", (Object)Gui.this.getText("ui.nextImage")), new Item((Object)"togglecontrols", (Object)Gui.this.getText("ui.toggleThumbstrip"))});
                        this.enableMouseWheel.setToolTipText(Gui.this.getText("ui.enableMouseWheelInfo"));
                        this.enableKeyboard.setToolTipText(Gui.this.getText("ui.enableKeyboardInfo"));
                        this.add("", this.enableMouseWheel);
                        this.add("tab", this.enableKeyboard);
                        this.add("br", new JLabel(Gui.this.getText("ui.clickAction")));
                        this.add("tab", this.clickAction);
                    }
                };
                this.transitionType.addItemListener(listener -> {
                    int p;
                    int t;
                    double d;
                    if (!Gui.this.isSkinReady()) {
                        return;
                    }
                    Item i = (Item)this.transitionType.getSelectedItem();
                    switch ((String)i.value) {
                        case "crossfade": {
                            d = 3.0;
                            t = 1000;
                            p = 16;
                            break;
                        }
                        case "zoom": {
                            d = 3.0;
                            t = 1000;
                            p = 16;
                            break;
                        }
                        case "kenburns": {
                            d = 0.0;
                            t = 4000;
                            p = 0;
                            break;
                        }
                        case "stack": {
                            d = 2.8;
                            t = 1200;
                            p = 32;
                            break;
                        }
                        case "slide": {
                            d = 3.2;
                            t = 800;
                            p = 16;
                            break;
                        }
                        case "swap": {
                            d = 2.0;
                            t = 2000;
                            p = 48;
                            break;
                        }
                        case "carousel": {
                            d = 3.0;
                            t = 1000;
                            p = 16;
                            break;
                        }
                        case "flip": {
                            d = 3.0;
                            t = 1000;
                            p = 64;
                            break;
                        }
                        case "book": {
                            d = 3.0;
                            t = 1000;
                            p = 64;
                            break;
                        }
                        case "cube": {
                            d = 3.0;
                            t = 1000;
                            p = 64;
                            break;
                        }
                        case "coverflow": {
                            d = 3.0;
                            t = 1000;
                            p = 0;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    this.transitionSpeed.setValue(t);
                    this.slideshowDelay.setValue(d);
                    this.fitPadding.setValue(p);
                });
                this.add("hfill", (Component)this.behaviorPanel);
                this.add("br hfill", (Component)this.mainImagePanel);
                this.add("br hfill", (Component)this.navigation);
            }

            public void importVariables(Map<String, Object> vars) {
                Map skinVars = Gui.this.engine.getSkinVariables();
                Object sdo = skinVars.get("slideshowDelay");
                if (sdo != null && sdo instanceof Double && (Double)sdo > 0.0 && (Double)sdo < 20.0) {
                    vars.put("slideshowDelay", (int)((Double)sdo * 1000.0));
                }
            }
        };
        ControlPanel imageCaption = new ControlPanel(Gui.access$200(Gui.this, "ui.caption")){
            JComboBox captionPlacement;
            JComboBox captionStyle;
            JComboBox<NameValue<String>> presets;
            JTextArea imageCaptionTemplate;
            JScrollPane imageCaptionPane;
            JCheckBox showImageNumbers;
            {
                this.captionPlacement = new JComboBox<Object>(new Object[]{new Item((Object)"left top", (Object)Gui.this.getText("ui.left_top")), new Item((Object)"center top", (Object)Gui.this.getText("ui.center_top")), new Item((Object)"right top", (Object)Gui.this.getText("ui.right_top")), new Item((Object)"left middle", (Object)Gui.this.getText("ui.left_middle")), new Item((Object)"center middle", (Object)Gui.this.getText("ui.center_middle")), new Item((Object)"right middle", (Object)Gui.this.getText("ui.right_middle")), new Item((Object)"left bottom", (Object)Gui.this.getText("ui.left_bottom")), new Item((Object)"center bottom", (Object)Gui.this.getText("ui.center_bottom")), new Item((Object)"right bottom", (Object)Gui.this.getText("ui.right_bottom"))});
                this.captionStyle = new JComboBox<Object>(new Object[]{new Item((Object)"white", (Object)Gui.this.getText("ui.white")), new Item((Object)"light", (Object)Gui.this.getText("ui.light")), new Item((Object)"transparent", (Object)Gui.this.getText("ui.transparent")), new Item((Object)"dark", (Object)Gui.this.getText("ui.dark")), new Item((Object)"black", (Object)Gui.this.getText("ui.black"))});
                this.presets = new JComboBox<NameValue>(new NameValue[]{new NameValue(Gui.this.getText("ui.empty"), (Object)""), new NameValue(Gui.this.getText("ui.title"), (Object)"<h6>${fileTitle}</h6>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.comment"), (Object)"<h5>${fileTitle}</h5>\n<div class=\"comment\">${comment}</div>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.commentShort"), (Object)"<h6>${fileTitle}</h6>\n<div class=\"comment\">${commentShort}</div>"), new NameValue(Gui.this.getText("ui.fileLabel"), (Object)"<h5>${fileLabel}</h5>"), new NameValue(Gui.this.getText("ui.fileLabel") + " + " + Gui.this.getText("ui.comment") + " (" + Gui.this.getText("ui.default") + ")", (Object)"<h5>${fileLabel}</h5>\n<div class=\"comment\">${comment}</div>"), new NameValue(Gui.this.getText("ui.fileLabel") + " + " + Gui.this.getText("ui.commentShort"), (Object)"<h5>${fileLabel}</h5>\n<div class=\"comment\">${commentShort}</div>"), new NameValue(Gui.this.getText("ui.title") + " + " + Gui.this.getText("ui.comment") + " + " + Gui.this.getText("author") + " + " + Gui.this.getText("keywords"), (Object)"<h5>${fileLabel}</h5>\n<div class=\"comment\">${comment}</div>\n<div class=\"comment\"><small class=\"icon-user\"> ${author}</small> <small class=\"icon-label\"> ${keywords}</small></div>")});
                this.imageCaptionTemplate = new JSmartTextArea(3, 30);
                this.imageCaptionPane = new JScrollPane(this.imageCaptionTemplate);
                this.showImageNumbers = new JCheckBox(Gui.this.getText("ui.showImageNumbers"));
                this.presets.addItemListener(listener -> {
                    if (!Gui.this.isSkinReady()) {
                        return;
                    }
                    this.imageCaptionTemplate.setText((String)((NameValue)this.presets.getSelectedItem()).value);
                });
                this.imageCaptionTemplate.setEditable(true);
                this.imageCaptionTemplate.setLineWrap(true);
                this.imageCaptionTemplate.setWrapStyleWord(true);
                this.imageCaptionTemplate.setFont(Gui.this.mono);
                this.imageCaptionTemplate.setTabSize(2);
                this.imageCaptionPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.captionTemplate")));
                this.showImageNumbers.setToolTipText(Gui.this.getText("ui.showImageNumbersInfo"));
                this.add("", (Component)new JLabelFor(Gui.this.getText("ui.position"), (JComponent)this.captionPlacement));
                this.add("tab", this.captionPlacement);
                this.add("", (Component)new JLabelFor(Gui.this.getText("ui.style"), (JComponent)this.captionStyle));
                this.add("tab", this.captionStyle);
                this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.presets"), this.presets));
                this.add("tab", this.presets);
                this.add("br hfill", this.imageCaptionPane);
                this.add("br", this.showImageNumbers);
            }
        };
        ControlPanel buttons = new ControlPanel(Gui.access$200(Gui.this, "ui.buttons")){
            JCheckBox showMap;
            JCheckBox showRegions;
            JCheckBox regionsVisible;
            private JLabel buttonLabel;
            JTextField regionsBtnText;
            JCheckBox regionsSkipEmpty;
            JCheckBox printImageButton;
            JCheckBox showDownload;
            JCheckBox useAudioClips;
            JLabel volumeLabel;
            JSpinner audioClipVolume;
            JCheckBox copyAudioClips;
            JCheckBox downloadNonImages;
            JCheckBox downloadScaled;
            JCheckBox useFotomoto;
            JTextField fotomotoID;
            JLabel mandatoryInfo;
            JCheckBox showPhotoData;
            ControlPanel photoData;
            {
                this.showMap = new JCheckBox(Gui.this.getText("ui.map"), true);
                this.showRegions = new JCheckBox(Gui.this.getText("ui.regions"), true);
                this.regionsVisible = new JCheckBox(Gui.this.getText("ui.visibleByDefault"));
                this.buttonLabel = new JLabel(Gui.this.getText("ui.buttonLabel"));
                this.regionsBtnText = new JTextField(Gui.this.getText("regions"), 8);
                this.regionsSkipEmpty = new JCheckBox(Gui.this.getText("ui.skipEmptyTags"));
                this.printImageButton = new JCheckBox(Gui.this.getText("ui.print"));
                this.showDownload = new JCheckBox(Gui.this.getText("ui.download"));
                this.useAudioClips = new JCheckBox(Gui.this.getText("ui.audioClip"));
                this.volumeLabel = new JLabel(Gui.this.getText("ui.initialVolume"));
                this.audioClipVolume = new JSpinner(new SpinnerNumberModel(75, 1, 100, 1));
                this.copyAudioClips = new JCheckBox(Gui.this.getText("ui.copyAudioClips"));
                this.downloadNonImages = new JCheckBox(Gui.this.getText("ui.enableDownloadNonImages"));
                this.downloadScaled = new JCheckBox(Gui.this.getText("ui.enableDownloadScaledImages"));
                this.useFotomoto = new JCheckBox(Gui.this.getText("ui.fotomoto"));
                this.fotomotoID = new JSmartTextField(16);
                this.mandatoryInfo = new JLabel(mandatory);
                this.showPhotoData = new JCheckBox(Gui.this.getText("ui.showPhotoData"));
                this.photoData = new ControlPanel(){
                    JCheckBox showPhotoDataLabel;
                    JTextArea photoDataTemplate;
                    JScrollPane photoDataPane;
                    JButton reset;
                    JLabel listMetadataHint;
                    {
                        this.showPhotoDataLabel = new JCheckBox(Gui.this.getText("ui.showLabel"), true);
                        this.photoDataTemplate = new JSmartTextArea(12, 30);
                        this.photoDataPane = new JScrollPane(this.photoDataTemplate);
                        this.reset = new JButton(Gui.this.getText("ui.resetToDefaults"));
                        this.listMetadataHint = new JLabel("<html><i>" + Gui.this.getText("ui.listMetadataHint") + "</i></html>");
                        this.showPhotoDataLabel.setToolTipText(Gui.this.getText("ui.showLabelInfo"));
                        this.photoDataTemplate.setEditable(true);
                        this.photoDataTemplate.setLineWrap(true);
                        this.photoDataTemplate.setWrapStyleWord(true);
                        this.photoDataTemplate.setFont(Gui.this.mono);
                        this.reset.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseReleased(MouseEvent e) {
                                String s;
                                if (reset.isEnabled() && (s = new SkinModel().photoDataTemplate) != null && s.length() > 0) {
                                    photoDataTemplate.setText(s);
                                }
                            }
                        });
                        this.add("", this.showPhotoDataLabel);
                        this.add(" ", this.reset);
                        this.add("br hfill vfill", this.photoDataPane);
                        this.add("br", this.listMetadataHint);
                    }
                };
                this.showMap.setToolTipText(Gui.this.getText("ui.mapInfo"));
                this.showRegions.setToolTipText(Gui.this.getText("ui.regionsInfo"));
                this.regionsVisible.setToolTipText(Gui.this.getText("ui.regionsVisibleInfo"));
                ComponentUtilities.whenSelectedEnable((AbstractButton)this.showRegions, (JComponent[])new JComponent[]{this.regionsVisible, this.buttonLabel, this.regionsBtnText, this.regionsSkipEmpty});
                showShare.setToolTipText(Gui.this.getText("ui.shareInfo"));
                this.printImageButton.setToolTipText(Gui.this.getText("ui.printInfo"));
                this.showDownload.setToolTipText(Gui.this.getText("ui.downloadInfo"));
                ComponentUtilities.whenSelectedEnable((AbstractButton)this.showDownload, (JComponent[])new JComponent[]{this.downloadScaled, this.downloadNonImages});
                this.downloadNonImages.setToolTipText(Gui.this.getText("ui.enableDownloadNonImagesInfo"));
                this.useAudioClips.setToolTipText(Gui.this.getText("ui.audioClipInfo"));
                ComponentUtilities.whenSelectedEnable((AbstractButton)this.useAudioClips, (JComponent[])new JComponent[]{this.volumeLabel, this.audioClipVolume, this.copyAudioClips});
                this.audioClipVolume.setToolTipText(Gui.this.getText("ui.audioClipVolumeInfo"));
                this.copyAudioClips.setToolTipText(Gui.this.getText("ui.copyAudioClipsInfo") + " (" + Gui.this.getText("ui.oldMethod") + ")");
                this.fotomotoID.setToolTipText(Gui.this.getText("ui.fotomotoIDInfo"));
                this.mandatoryInfo.setToolTipText(Gui.this.getText("ui.mandatory"));
                ComponentUtilities.whenSelectedEnable((AbstractButton)this.useFotomoto, (JComponent[])new JComponent[]{this.fotomotoID, this.mandatoryInfo});
                this.showPhotoData.setToolTipText(Gui.this.getText("ui.showPhotoDataInfo"));
                ComponentUtilities.whenSelectedEnable((AbstractButton)this.showPhotoData, (JComponent[])new JComponent[]{this.photoData});
                this.add("", new JLabel(Gui.icon("location")));
                this.add("tab", this.showMap);
                this.add("br", new JLabel(Gui.icon("facetag")));
                this.add("tab", this.showRegions);
                this.add("tab", this.regionsVisible);
                this.add(" ", this.buttonLabel);
                this.add("", this.regionsBtnText);
                this.add(" ", this.regionsSkipEmpty);
                this.add("br", new JLabel(Gui.icon("connect")));
                this.add("tab", showShare);
                this.add("br", new JLabel(Gui.icon("location")));
                this.add("tab", this.printImageButton);
                this.add("br", new JLabel(Gui.icon("download")));
                this.add("tab", this.showDownload);
                this.add("tab", this.downloadScaled);
                this.add(" ", this.downloadNonImages);
                this.add("br", new JLabel(Gui.icon("volume-up")));
                this.add("tab", this.useAudioClips);
                this.add("tab", this.volumeLabel);
                this.add("", this.audioClipVolume);
                this.add("", this.copyAudioClips);
                this.add("br", new JLabel(Gui.icon("fotomoto")));
                this.add("tab", this.useFotomoto);
                this.add(" ", (Component)new JLabelFor(Gui.this.getText("ui.storeId"), (JComponent)this.fotomotoID));
                this.add(this.mandatoryInfo);
                this.add("", this.fotomotoID);
                this.add((Component)new JLinkLabel("https://my.fotomoto.com/signup", Gui.this.getText("ui.signUp")));
                this.add("br", new JLabel(Gui.icon("camera")));
                this.add("tab", this.showPhotoData);
                this.add("br hfill", (Component)this.photoData);
            }
        };
        ControlPanel customCodePanel = new ControlPanel(){
            ControlPanel headHookTab = new ControlPanel(){
                JTextArea headHook = new JSmartTextArea(7, 20);
                JScrollPane headHookPane = new JScrollPane(this.headHook);
                {
                    this.headHook.setEditable(true);
                    this.headHook.setLineWrap(false);
                    this.headHook.setFont(Gui.this.mono);
                    this.headHook.setTabSize(2);
                    this.headHookPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.headText")));
                    this.add("hfill vfill", this.headHookPane);
                }
            };
            ControlPanel bodyHookTab = new ControlPanel(){
                JTextArea bodyHook = new JSmartTextArea(7, 20);
                JScrollPane bodyHookPane = new JScrollPane(this.bodyHook);
                {
                    this.bodyHook.setEditable(true);
                    this.bodyHook.setLineWrap(false);
                    this.bodyHook.setFont(Gui.this.mono);
                    this.bodyHook.setTabSize(2);
                    this.bodyHookPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.bodyText")));
                    this.add("hfill vfill", this.bodyHookPane);
                }
            };
            ControlPanel cssHookTab = new ControlPanel(){
                JTextArea cssHook = new JSmartTextArea(15, 20);
                JScrollPane cssHookPane = new JScrollPane(this.cssHook);
                WrappableJLabel info;
                {
                    this.info = new WrappableJLabel("<html><i>" + Gui.this.getText("ui.cssText") + "</i></html>");
                    this.cssHook.setEditable(true);
                    this.cssHook.setLineWrap(false);
                    this.cssHook.setFont(Gui.this.mono);
                    this.cssHook.setTabSize(2);
                    this.cssHookPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.cssTitle")));
                    this.info.setPreferredWidth(700);
                    this.add("hfill vfill", this.cssHookPane);
                    this.add("br", (Component)this.info);
                }
            };
            ControlPanel jsHookTab = new ControlPanel(){
                JTextArea jsHook = new JSmartTextArea(15, 20);
                JScrollPane jsHookPane = new JScrollPane(this.jsHook);
                WrappableJLabel info;
                {
                    this.info = new WrappableJLabel("<html><i>" + Gui.this.getText("ui.javascriptText") + "</i></html>");
                    this.jsHook.setEditable(true);
                    this.jsHook.setLineWrap(false);
                    this.jsHook.setFont(Gui.this.mono);
                    this.jsHook.setTabSize(2);
                    this.jsHookPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.javascriptTitle")));
                    this.info.setPreferredWidth(700);
                    this.add("hfill vfill", this.jsHookPane);
                    this.add("br", (Component)this.info);
                }
            };
            JTabbedPane customCodeTabs = new JTabbedPane(){
                {
                    this.addTab("<HEAD>", Gui.icon("code"), (Component)headHookTab);
                    this.addTab("<BODY>", Gui.icon("code"), (Component)bodyHookTab);
                    this.addTab("CSS", Gui.icon("css"), (Component)cssHookTab);
                    this.addTab("JavaScript", Gui.icon("javascript"), (Component)jsHookTab);
                }
            };
            {
                this.add("hfill vfill", this.customCodeTabs);
            }
        };
        ControlPanel siteAdminPanel = new ControlPanel(){
            ControlPanel serverRelatedPanel;
            ControlPanel imageRelatedPanel;
            ControlPanel googlePanel;
            ControlPanel seoPanel;
            ControlPanel cookiePolicyPanel;
            JCheckBox debugMode;
            ControlPanel leftPanel;
            ControlPanel rightPanel;
            {
                this.serverRelatedPanel = new ControlPanel(Gui.this.getText("ui.serverRelated")){
                    JTextField uploadPath;
                    JCheckBox useFavicon;
                    JCheckBox useMsServer;
                    JCheckBox useExpiry;
                    JCheckBox useRobotsTxt;
                    JCheckBox avoidCDNs;
                    JCheckBox copyGoogleFonts;
                    JCheckBox addLatinExt;
                    WrappableJLabel uploadPathInfo;
                    {
                        this.uploadPath = new JSmartTextField(20);
                        this.useFavicon = new JCheckBox(Gui.this.getText("ui.useTheSkinsFavicon"), true);
                        this.useMsServer = new JCheckBox(Gui.this.getText("ui.useMsServer"));
                        this.useExpiry = new JCheckBox(Gui.this.getText("ui.useExpiry"), false);
                        this.useRobotsTxt = new JCheckBox(Gui.this.getText("ui.useRobotsTxt"), false);
                        this.avoidCDNs = new JCheckBox(Gui.this.getText("ui.avoidCDNs"), false);
                        this.copyGoogleFonts = new JCheckBox(Gui.this.getText("ui.copyGoogleFonts"), false);
                        this.addLatinExt = new JCheckBox(Gui.this.getText("ui.addLatinExtended"), true);
                        this.uploadPathInfo = new WrappableJLabel("<html><i>" + Gui.this.getText("ui.copyPasteAlbumURLHere") + "</i></html>");
                        this.uploadPath.setToolTipText(Gui.this.getText("ui.uploadPathInfo"));
                        this.uploadPathInfo.setPreferredWidth(360);
                        this.useFavicon.setToolTipText(Gui.this.getText("ui.useFaviconInfo"));
                        this.useMsServer.setToolTipText(Gui.this.getText("ui.useMsServerInfo"));
                        this.useExpiry.setToolTipText(Gui.this.getText("ui.useExpiryInfo"));
                        this.useRobotsTxt.setToolTipText(Gui.this.getText("ui.useRobotsTxtInfo"));
                        this.avoidCDNs.setToolTipText(Gui.this.getText("ui.avoidCDNsInfo"));
                        this.copyGoogleFonts.setToolTipText(Gui.this.getText("ui.copyGoogleFontsInfo"));
                        this.addLatinExt.setToolTipText(Gui.this.getText("ui.addLatinExtendedInfo"));
                        this.add(new JLabel(Gui.this.getText("ui.uploadPath")));
                        this.add("", this.uploadPath);
                        this.add("br", new JLabel(infoIcon));
                        this.add("", (Component)this.uploadPathInfo);
                        this.add("br", this.useFavicon);
                        this.add(" ", new JLabel(Gui.svgIcon("favicon", new Dimension(24, 24))));
                        this.add("br", this.useMsServer);
                        this.add("br", this.useExpiry);
                        this.add("br", this.useRobotsTxt);
                        this.add("br", this.avoidCDNs);
                        this.add("br", this.copyGoogleFonts);
                        this.add("br", this.addLatinExt);
                    }
                };
                this.imageRelatedPanel = new ControlPanel(Gui.this.getText("ui.images")){
                    JCheckBox hiDpiThemeImage;
                    JComboBox shareImageDims;
                    {
                        this.hiDpiThemeImage = new JCheckBox(Gui.this.getText("ui.hiDpiThemeImage"));
                        this.shareImageDims = new JComboBox<Object>(new Object[]{"640x480", "1024x768", "1200x900", "1600x1200"});
                        this.shareImageDims.setEditable(true);
                        this.add(this.hiDpiThemeImage);
                        this.add("br", new JLabel(Gui.this.getText("ui.shareImageDimensions")));
                        this.add("", this.shareImageDims);
                    }
                };
                this.googlePanel = new ControlPanel(Gui.this.getText("ui.googleAnalytics")){
                    JComboBox googleAnalytics;
                    JTextField googleSiteID;
                    JLabel mandatoryInfo;
                    JCheckBox supportDoubleclick;
                    {
                        this.googleAnalytics = new JComboBox<Object>(new Object[]{new Item((Object)"none", (Object)Gui.this.getText("ui.none")), new Item((Object)"gtag", (Object)"Global Site Tag (gtag.js)"), new Item((Object)"universal", (Object)"Universal (analytics.js)"), new Item((Object)"classic", (Object)"Classic (ga.js) [Legacy]")});
                        this.googleSiteID = new JSmartTextField(20);
                        this.mandatoryInfo = new JLabel(mandatory);
                        this.supportDoubleclick = new JCheckBox(Gui.this.getText("ui.supportDoubleclick"), false);
                        this.googleSiteID.setToolTipText(Gui.this.getText("ui.googleSiteIDInfo"));
                        this.mandatoryInfo.setToolTipText(Gui.this.getText("ui.mandatory"));
                        this.add("", (Component)new JLabelFor(Gui.this.getText("ui.version"), (JComponent)this.googleAnalytics));
                        this.add(" ", this.googleAnalytics);
                        this.add(" ", (Component)new JLinkLabel("https://www.google.com/analytics/", Gui.this.getText("ui.signUp")));
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.googleSiteID"), (JComponent)this.googleSiteID));
                        this.add(this.mandatoryInfo);
                        this.add("", this.googleSiteID);
                        this.add("br", this.supportDoubleclick);
                    }
                };
                this.seoPanel = new ControlPanel(Gui.this.getText("ui.searchEngineOptimization")){
                    JTextField titleSEOText;
                    JTextField descriptionSEOText;
                    JSpinner preloadThumbs;
                    JCheckBox addAltTags;
                    JCheckBox slideRedirect;
                    {
                        this.titleSEOText = new JSmartTextField(20);
                        this.descriptionSEOText = new JSmartTextField(20);
                        this.preloadThumbs = new JSpinner(new SpinnerNumberModel(20, 0, 1000, 10));
                        this.addAltTags = new JCheckBox(Gui.this.getText("ui.addAltTags"), true);
                        this.slideRedirect = new JCheckBox(Gui.this.getText("ui.redirectSlidePages"), true);
                        this.titleSEOText.setToolTipText(Gui.this.getText("ui.titleSEOTextInfo"));
                        this.descriptionSEOText.setToolTipText(Gui.this.getText("ui.descriptionSEOTextInfo"));
                        this.addAltTags.setToolTipText(Gui.this.getText("ui.addAltTagsInfo"));
                        writeSitemapXml.setToolTipText(Gui.this.getText("ui.createSitemapXmlInfo"));
                        ComponentUtilities.whenSelectedEnable((AbstractButton)writeSitemapXml, (JComponent[])new JComponent[]{sitemapIncludeSlides});
                        sitemapIncludeSlides.setToolTipText(Gui.this.getText("ui.sitemapIncludeSlidesInfo"));
                        this.slideRedirect.setToolTipText(Gui.this.getText("ui.redirectSlidePagesInfo"));
                        this.add("", (Component)new JLabelFor(Gui.this.getText("ui.titleSEOText"), (JComponent)this.titleSEOText));
                        this.add("tab", this.titleSEOText);
                        this.add("br", (Component)new JLabelFor(Gui.this.getText("ui.descriptionSEOText"), (JComponent)this.descriptionSEOText));
                        this.add("tab", this.descriptionSEOText);
                        this.add("br", new JLabel(Gui.this.getText("ui.preloadThumbs")));
                        this.add("", this.preloadThumbs);
                        this.add("br", this.addAltTags);
                        this.add("br", writeSitemapXml);
                        this.add("", sitemapIncludeSlides);
                        this.add("br", this.slideRedirect);
                    }
                };
                this.cookiePolicyPanel = new ControlPanel(Gui.this.getText("ui.trackingConsentAndCookiePolicy")){
                    JCheckBox askTrackingConsent;
                    JCheckBox showCookiePolicy;
                    JTextField cookiePolicyStay;
                    JTextField cookiePolicyUrl;
                    WrappableJLabel cookiePolicyUrlInfo;
                    {
                        this.askTrackingConsent = new JCheckBox(Gui.this.getText("ui.askTrackingConsent"), false);
                        this.showCookiePolicy = new JCheckBox(Gui.this.getText("ui.showCookiePolicy"), false);
                        this.cookiePolicyStay = new JSmartTextField("8", 3);
                        this.cookiePolicyUrl = new JSmartTextField(20);
                        this.cookiePolicyUrlInfo = new WrappableJLabel("<html><i>" + Gui.this.getText("ui.cookiePolicyUrlInfo") + " </i></html>");
                        this.askTrackingConsent.setToolTipText(Gui.this.getText("ui.askTrackingConsentInfo"));
                        this.showCookiePolicy.setToolTipText(Gui.this.getText("ui.showCookiePolicyInfo"));
                        this.cookiePolicyUrlInfo.setPreferredWidth(320);
                        this.add(this.askTrackingConsent);
                        this.add("br", this.showCookiePolicy);
                        this.add(" ", new JLabel(Gui.this.getText("ui.stay")));
                        this.add("", this.cookiePolicyStay);
                        this.add("", new JLabel("s"));
                        this.add("br", new JLabel("URL"));
                        this.add("tab", this.cookiePolicyUrl);
                        this.add("br", new JLabel(infoIcon));
                        this.add("tab", (Component)this.cookiePolicyUrlInfo);
                    }
                };
                this.debugMode = new JCheckBox(Gui.this.getText("ui.debugMode"));
                this.leftPanel = new ControlPanel(){
                    {
                        this.add("hfill", (Component)serverRelatedPanel);
                        this.add("br hfill", (Component)googlePanel);
                        this.add("br", debugMode);
                    }
                };
                this.rightPanel = new ControlPanel(){
                    {
                        this.add("hfill", (Component)imageRelatedPanel);
                        this.add("br hfill", (Component)seoPanel);
                        this.add("br hfill", (Component)cookiePolicyPanel);
                    }
                };
                this.add((Component)this.leftPanel);
                this.add((Component)this.rightPanel);
            }
        };
        ControlPanel customKeysPanel = new ControlPanel(){
            JTextArea customKeys = new JSmartTextArea(7, 20);
            JScrollPane customKeysPane = new JScrollPane(this.customKeys);
            {
                this.customKeys.setEditable(true);
                this.customKeys.setLineWrap(false);
                this.customKeys.setFont(Gui.this.mono);
                this.customKeys.setTabSize(2);
                this.customKeysPane.setBorder(BorderFactory.createTitledBorder(Gui.this.getText("ui.customKeys")));
                this.add("hfill vfill", this.customKeysPane);
                this.add("br", new JLabel(Gui.this.getText("ui.customKeysInfo")));
            }
        };
        ControlPanel site = new ControlPanel(new BorderLayout(20, 0)){
            JTabbedPane siteTabs;
            JPanel designPreviewPanel;
            {
                this.siteTabs = new JTabbedPane(){
                    JScrollPane pageDesignPane;
                    {
                        this.pageDesignPane = new JScrollPane((Component)pageDesign, 20, 31);
                        this.pageDesignPane.setBorder(Gui.this.emptyBorder);
                        this.setTabPlacement(2);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.design") + "</h4></html>", Gui.icon("design"), this.pageDesignPane);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.typography") + "</h4></html>", Gui.icon("font"), (Component)typography);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.header") + "</h4></html>", Gui.icon("header"), (Component)coverHeader);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.title") + "</h4></html>", Gui.icon("hero"), (Component)coverTitle);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.folders") + "</h4></html>", Gui.icon("folder"), (Component)folders);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.footer") + "</h4></html>", Gui.icon("footer"), (Component)footerTab);
                    }
                };
                this.designPreviewPanel = new JPanel(new BorderLayout(0, 0)){
                    {
                        designPreview.getView().setPreferredSize(new Dimension(520, 560));
                        this.add((Component)designPreview.getView(), "Center");
                    }
                };
                ((BorderLayout)this.getLayout()).setVgap(0);
                ((BorderLayout)this.getLayout()).setHgap(0);
                this.siteTabs.setBorder(Gui.this.emptyBorder);
                this.siteTabs.setPreferredSize(new Dimension(600, 560));
                this.designPreviewPanel.setBorder(BorderFactory.createLineBorder(JAlbumColor.imageBorder, 2));
                this.add(this.siteTabs);
                this.add(this.designPreviewPanel, "East");
            }
        };
        ControlPanel sidebar = new ControlPanel(new BorderLayout(0, 0)){
            ControlPanel ordering;
            JTabbedPane sidebarTabs;
            {
                this.ordering = new ControlPanel(){
                    JList sidebarOrder;
                    {
                        this.sidebarOrder = new JDraggableList(new Object[]{new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.navigation") + "</p></html>", Gui.icon("folders")).name("navigation"), new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.search") + "</p></html>", Gui.icon("search")).name("search"), new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.tags") + "</p></html>", Gui.icon("tag")).name("tags"), new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.searchNew") + "</p></html>", Gui.icon("new")).name("newImages"), new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.map") + "</p></html>", Gui.icon("location")).name("map"), new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.social") + "</p></html>", Gui.icon("connect")).name("social"), new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.fullScreen") + "</p></html>", Gui.icon("fullscreen")).name("fullscreen"), new JLabelFor("<html><p style=\"padding:3px 0;\">" + Gui.this.getText("ui.backgroundMusic") + "</p></html>", Gui.icon("audio")).name("music")});
                        this.add("center", new JLabel("<html><h4>" + Gui.this.getText("ui.ordering") + "</h4></html>"));
                        this.add("br", this.sidebarOrder);
                        this.add("br center", new JLabel("<html><i>" + Gui.this.getText("ui.dragToReorder") + "</i></html>"));
                    }
                };
                this.sidebarTabs = new JTabbedPane(){
                    JScrollPane socialPanel;
                    {
                        this.socialPanel = new JScrollPane((Component)social, 20, 31);
                        this.setTabPlacement(2);
                        this.socialPanel.setBorder(Gui.this.emptyBorder);
                        search.setBorder(Gui.this.emptyBorder);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.navigation") + "</h4></html>", Gui.icon("folders"), (Component)topNavigation);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.search") + "</h4></html>", Gui.icon("search"), (Component)search);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.tagCloud") + "</h4></html>", Gui.icon("tag"), (Component)tagCloud);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.searchNew") + "</h4></html>", Gui.icon("new"), (Component)searchNew);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.map") + "</h4></html>", Gui.icon("location"), (Component)map);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.social") + "</h4></html>", Gui.icon("connect"), this.socialPanel);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.fullScreen") + "</h4></html>", Gui.icon("fullscreen"), (Component)fullScreen);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.backgroundMusic") + "</h4></html>", Gui.icon("audio"), (Component)backgroundMusic);
                    }
                };
                ((BorderLayout)this.getLayout()).setVgap(0);
                ((BorderLayout)this.getLayout()).setHgap(0);
                this.sidebarTabs.setBorder(Gui.this.emptyBorder);
                this.sidebarTabs.setPreferredSize(new Dimension(600, 560));
                this.add(this.sidebarTabs);
                this.add((Component)this.ordering, "East");
            }
        };
        ControlPanel lightbox = new ControlPanel(new BorderLayout(0, 0)){
            JTabbedPane lightboxTabs;
            {
                this.lightboxTabs = new JTabbedPane(){
                    JScrollPane markNewPane;
                    JScrollPane mainImagePanel;
                    {
                        this.markNewPane = new JScrollPane((Component)markNew, 20, 31);
                        this.mainImagePanel = new JScrollPane((Component)mainImage, 20, 31);
                        this.setTabPlacement(2);
                        thumbnailStrip.setBorder(Gui.this.emptyBorder);
                        this.markNewPane.setBorder(Gui.this.emptyBorder);
                        this.mainImagePanel.setBorder(Gui.this.emptyBorder);
                        imageCaption.setBorder(Gui.this.emptyBorder);
                        buttons.setBorder(Gui.this.emptyBorder);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.thumbnailStrip") + "</h4></html>", Gui.icon("thumbnails"), (Component)thumbnailStrip);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.markNew") + "</h4></html>", Gui.icon("new"), this.markNewPane);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.mainImage") + "</h4></html>", Gui.icon("image"), this.mainImagePanel);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.caption") + "</h4></html>", Gui.icon("caption"), (Component)imageCaption);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.buttons") + "</h4></html>", Gui.icon("button"), (Component)buttons);
                    }
                };
                ((BorderLayout)this.getLayout()).setVgap(0);
                ((BorderLayout)this.getLayout()).setHgap(0);
                this.lightboxTabs.setBorder(Gui.this.emptyBorder);
                this.lightboxTabs.setPreferredSize(new Dimension(600, 560));
                this.add(this.lightboxTabs);
            }
        };
        ControlPanel advanced = new ControlPanel(new BorderLayout(0, 0)){
            JTabbedPane advancedTabs;
            {
                this.advancedTabs = new JTabbedPane(){
                    JScrollPane siteAdminPane;
                    {
                        this.siteAdminPane = new JScrollPane((Component)siteAdminPanel, 20, 31);
                        this.siteAdminPane.setBorder(Gui.this.emptyBorder);
                        customCodePanel.setBorder(Gui.this.emptyBorder);
                        customKeysPanel.setBorder(Gui.this.emptyBorder);
                        this.setTabPlacement(2);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.siteAdmin") + "</h4></html>", Gui.icon("wrench"), this.siteAdminPane);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.customCode") + "</h4></html>", Gui.icon("code"), (Component)customCodePanel);
                        this.addTab("<html><h4 style='padding:3px 4px;margin:3px 4px;'>" + Gui.this.getText("ui.customKeys") + "</h4></html>", Gui.icon("rename"), (Component)customKeysPanel);
                    }
                };
                ((BorderLayout)this.getLayout()).setVgap(0);
                ((BorderLayout)this.getLayout()).setHgap(0);
                this.advancedTabs.setBorder(Gui.this.emptyBorder);
                this.add(this.advancedTabs);
            }
        };
        ControlPanel about = new ControlPanel(new BorderLayout(20, 0)){
            private JTextArea readme;
            private JScrollPane aboutPane;
            ControlPanel info;
            {
                this.readme = new JSmartTextArea(Gui.this.getFileContents("readme.txt"), 20, 30);
                this.aboutPane = new JScrollPane(this.readme, 22, 31);
                this.info = new ControlPanel(){
                    {
                        this.add("center", new JLabel(Gui.svgIcon("logo-projector", new Dimension(120, 120))));
                        this.add("br center", new JLabel("<html><h2>" + Gui.this.skin + "</h2></html>"));
                        this.add("br center", new JLabel("Jalbum " + Gui.this.internalVersion));
                        this.add((Component)new JLinkLabel("https://jalbum.net/software/download", Gui.this.getText("ui.upgrade"), Gui.this.getText("ui.downloadJalbum")));
                        this.add("br center", new JLabel(Gui.this.skin + " skin " + Gui.this.skinVer));
                        this.add((Component)new JLinkLabel("https://jalbum.net/skins/skin/" + Gui.this.skin, Gui.this.getText("ui.upgrade"), Gui.this.getText("ui.downloadSkin")));
                        this.add("br center", (Component)new JLinkLabel(Gui.this.supportForum, Gui.this.getText("ui.support")));
                    }
                };
                ((BorderLayout)this.getLayout()).setVgap(0);
                ((BorderLayout)this.getLayout()).setHgap(0);
                this.readme.setLineWrap(true);
                this.readme.setWrapStyleWord(true);
                this.readme.setEditable(false);
                this.readme.setFont(Gui.this.mono);
                this.info.setPreferredSize(new Dimension(240, 560));
                this.aboutPane.setPreferredSize(new Dimension(600, 560));
                this.add((Component)this.info, "West");
                this.add(this.aboutPane);
            }
        };
        JTabbedPane tabs = new JTabbedPane(){
            {
                site.setBorder(Gui.this.emptyBorder);
                sidebar.setBorder(Gui.this.emptyBorder);
                lightbox.setBorder(Gui.this.emptyBorder);
                advanced.setBorder(Gui.this.emptyBorder);
                about.setBorder(Gui.this.emptyBorder);
                this.addTab("<html><h4 style='padding:4px 6px;margin:4px;'>" + Gui.this.getText("ui.site") + "</h4></html>", Gui.icon("site", 27), (Component)site);
                this.addTab("<html><h4 style='padding:4px 6px;margin:4px;'>" + Gui.this.getText("ui.sidebar") + "</h4></html>", Gui.icon("sidebar-left", 27), (Component)sidebar);
                this.addTab("<html><h4 style='padding:4px 6px;margin:4px;'>" + Gui.this.getText("ui.lightbox") + "</h4></html>", Gui.icon("lightbox", 27), (Component)lightbox);
                this.addTab("<html><h4 style='padding:4px 6px;margin:4px;'>" + Gui.this.getText("ui.advanced") + "</h4></html>", Gui.icon("wrench", 27), (Component)advanced);
                this.addTab("<html><h4 style='padding:4px 6px;margin:4px;'>" + Gui.this.getText("ui.about") + "</h4></html>", Gui.icon("info", 27), (Component)about);
            }
        };
        private final String designTemplate = Gui.access$2800(Gui.this, "lib/design-template.html");
        {
            ((RiverLayout)this.getLayout()).setVgap(0);
            ((RiverLayout)this.getLayout()).setHgap(0);
            this.tabs.setBorder(Gui.this.emptyBorder);
            this.add(this.tabs);
            Gui.this.window.addJAlbumListener((JAlbumListener)new JAlbumAdapter(){

                public void styleChanged(JAlbumEvent e) {
                    styleName.setText(Gui.this.getStyleName());
                }
            });
            Gui.this.window.addPropertyChangeListener("skinLoaded", this.setupMonitors);
            Gui.this.window.addJAlbumListener((JAlbumListener)new JAlbumAdapter(){

                public void skinChanged(JAlbumEvent e) {
                    Gui.this.window.removePropertyChangeListener("skinLoaded", setupMonitors);
                }
            });
            try {
                Gui.this.window.albumExplorer.onContextMenu(menu -> {
                    AlbumObject[] sel = Gui.this.window.albumExplorer.explorer.getSelectedAlbumObjects();
                    if (sel.length > 0) {
                        Gui.this.createMenuItemForBooleanProperty((JMenu)menu, sel, "panorama", Gui.this.getText("ui.panorama"));
                        Gui.this.createMenuItemForBooleanProperty((JMenu)menu, sel, "hideLocation", Gui.this.getText("ui.hideLocation"));
                    }
                });
            }
            catch (Throwable ex) {
                JAlbum.logger.log(Level.INFO, "Right-click extension menu is available only in jAlbum v32 and newer!");
            }
        }

        private void setFontBoxes() {
            if (this.fontSuggestions.getSelectedIndex() == 0) {
                return;
            }
            String s = this.fontSuggestions.getSelectedItem().toString();
            String hf = s.split("/")[0].trim();
            String ff = s.split("/")[1].trim();
            Gui.this.setSelectedValue(this.fontFamily, ff);
            Gui.this.setSelectedValue(this.headlineFont, hf);
            this.fontSuggestions.setSelectedIndex(0);
        }

        private void setMakeSlides() {
            boolean nv;
            boolean ov = Gui.this.engine.isSlides();
            boolean bl = nv = this.showShare.isSelected() && (this.shareFacebook.isSelected() || this.shareThreads.isSelected() || this.shareBluesky.isSelected()) || this.writeSitemapXml.isSelected() && this.sitemapIncludeSlides.isSelected();
            if (ov != nv) {
                try {
                    Gui.this.window.ui2Engine();
                    Gui.this.engine.setSlides(nv);
                    Gui.this.window.engine2UI();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        private void refreshDesignPreview() {
            String stylePath;
            String buttonTextColor;
            String sName = this.styleName.getText();
            String txtColor = this.heroTextColor.toString();
            Double sidebarAlpha = Gui.this.getAlpha(this.sidebarBackgroundColor.toString());
            Double textLuminosity = Gui.this.getLuminosity(txtColor);
            String bgRepeat = Gui.this.getSelectedValue(this.backgroundRepeat);
            String hbgRepeat = Gui.this.getSelectedValue(this.heroBackgroundRepeat);
            String bgColor = this.backgroundColor.toString();
            String sidebarBgColor = this.sidebarBackgroundColor.toString();
            String lightText = textLuminosity > 0.86 ? txtColor : "#eeeeee";
            String darkText = textLuminosity < 0.3 ? txtColor : "#333333";
            String sidebarTextColor = Gui.this.isLightColor(sidebarAlpha > 0.5 ? sidebarBgColor : bgColor) ? darkText : lightText;
            String string = buttonTextColor = Gui.this.getLuminosity(this.buttonColor.toString()) > 0.75 ? darkText : lightText;
            String panelBgColor = sidebarAlpha < 0.5 ? Gui.this.getCssColor(bgColor) : (sidebarAlpha >= 0.8 ? Gui.this.getCssColor(sidebarBgColor) : Gui.this.setAlpha(this.sidebarBackgroundColor.toString(), 0.9));
            try {
                stylePath = new File(Gui.this.skinDirectory, "styles/" + sName).toURI().toURL().toString();
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(Gui.class.getName()).log(Level.SEVERE, null, ex);
                stylePath = "";
            }
            String html = this.designTemplate.replace("{styleName}", sName).replace("{backgroundColor}", Gui.this.getCssColor(bgColor)).replace("{heroBackgroundColor}", Gui.this.getCssColor(this.heroBackgroundColor.toString())).replace("{sidebarBackgroundColor}", Gui.this.getCssColor(sidebarBgColor)).replace("{sidebarTextColor}", sidebarTextColor).replace("{panelBackgroundColor}", panelBgColor).replace("{heroTextColor}", this.heroTextColor.toString()).replace("{linkColor}", this.linkColor.toString()).replace("{hoverColor}", this.hoverColor.toString()).replace("{buttonColor}", Gui.this.getCssColor(this.buttonColor.toString())).replace("{buttonTextColor}", buttonTextColor).replace("{heroType}", Gui.this.getSelectedValue(this.heroType)).replace("{folderThumbType}", Gui.this.getSelectedValue(this.folderThumbType)).replace("{backgroundImage}", "url(" + stylePath + "/" + this.backgroundImageName.getText() + ")").replace("{backgroundPosition}", Gui.this.getSelectedValue(this.backgroundPos)).replace("{backgroundRepeat}", bgRepeat.equals("stretch") ? "background-size: cover" : "background-repeat: " + bgRepeat).replace("{sidebarBackgroundImage}", "url(" + stylePath + "/" + this.sidebarBackgroundImageName.getText() + ")").replace("{heroBackgroundImage}", "url(" + stylePath + "/" + this.heroBackgroundImageName.getText() + ")").replace("{heroBackgroundPosition}", Gui.this.getSelectedValue(this.heroBackgroundPos)).replace("{heroBackgroundRepeat}", hbgRepeat.equals("stretch") ? "background-size: cover" : "background-repeat: " + hbgRepeat);
            String html1 = html = Gui.this.getFonts(html, Gui.this.getSelectedValue(this.fontFamily), this.headlineFont.getSelectedIndex() == 0 ? "" : Gui.this.getSelectedValue(this.headlineFont));
            SwingUtilities.invokeLater(() -> this.designPreview.loadContent(html1));
        }
    };

    private boolean isSkinReady() {
        return System.currentTimeMillis() - this.skinReadyAt > 1000L;
    }

    private String getStyleName() {
        String style = this.engine.getStyle();
        return style.substring(0, style.indexOf("."));
    }

    private boolean isLightStyle() {
        String s = this.getStyleName();
        return "Cardboard,Creme,Exhibition,Hemp,Leather Light,Retro,Ricepaper,Shine,Stonewall,Wallpaper,White,Wood light,Yellow".indexOf(s) >= 0;
    }

    private String getSkinName() {
        return this.engine.getSkin();
    }

    private String getLastSkinName() {
        String ls = null;
        try {
            ls = this.engine.getLastSkin();
        }
        catch (Throwable t) {
            JAlbum.logger.log(Level.FINER, "Last skin is unknown.");
        }
        return ls;
    }

    private final String unCamelCase(String s) {
        if (s.length() > 0) {
            s = s.replaceAll("([a-z])([A-Z]+)", "$1 $2");
            return Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        return "";
    }

    private String getText(String t) {
        String s;
        try {
            s = this.texts.getString(t);
        }
        catch (MissingResourceException e) {
            JAlbum.logger.log(Level.FINE, "Missing text: \"{0}\"", t);
            if (t.startsWith("ui.")) {
                t = t.substring(3);
            }
            s = this.unCamelCase(t);
        }
        return s;
    }

    private String getFonts(String html, String ff, String hf) {
        String gf = "";
        String fw = "";
        String bw = "bold";
        String hw = "";
        if (ff.contains(":")) {
            gf = ff;
            fw = ff.split(":")[1];
            if (fw.length() > 0) {
                String[] w = fw.split(",");
                bw = w.length > 2 ? w[2] : w[1];
                fw = w[0];
            }
            if ((ff = ff.split(":")[0]).contains(" ")) {
                ff = "\"" + ff + "\"";
            }
            ff = ff + ",sans-serif";
        }
        if (!hf.equals("")) {
            if (!hf.equals(gf)) {
                String string = gf = gf.length() > 0 ? gf + "|" + hf : hf;
            }
            if (hf.contains(":")) {
                hw = hf.split(":")[1];
                if (hw.length() > 0) {
                    hw = hw.split(",")[0];
                }
                hf = hf.split(":")[0];
            }
            if (hf.contains(" ")) {
                hf = "\"" + hf + "\"";
            }
            hf = hf + ",sans-serif";
        }
        return html.replace("{googleFontsLink}", gf.length() == 0 ? "" : "\t<link rel=\"stylesheet\" href=\"http://fonts.googleapis.com/css?family=" + gf.replaceAll(" ", "+") + "&display=swap\">\n").replace("{fontFamily}", ff).replace("{fontWeight}", fw.equals("") ? "300" : fw).replace("{boldWeight}", bw).replace("{headlineFont}", hf.equals("") ? "inherit" : hf).replace("{headlineWeight}", hw.equals("") ? "400" : hw);
    }

    private String attemptSignIn() {
        SignInManager mgr = SignInManager.getInstance();
        if (mgr != null && mgr.isSignedIn()) {
            return "&cid=" + AccountManager.getCid((String)mgr.getUserName(), (String)mgr.getPassword());
        }
        return "";
    }

    private String getFileContents(String name) {
        StringBuilder cont = new StringBuilder();
        String nl = System.getProperty("line.separator");
        File f = new File(this.skinDirectory, name);
        if (f.exists()) {
            try (BufferedReader in = new BufferedReader(new FileReader(f));){
                String line;
                while ((line = in.readLine()) != null) {
                    cont.append(line);
                    cont.append(nl);
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return cont.toString();
    }

    private void writeFile(String fileName, String cont) {
        File out = new File(fileName);
        try {
            FileWriter writer = new FileWriter(out, false);
            writer.write(cont);
            writer.close();
        }
        catch (IOException e) {
            JAlbum.logger.log(Level.FINE, "Error writing \"{0}\".", fileName);
        }
    }

    private Color toColor(JColorSelector cs) {
        return this.toColor(cs.toString());
    }

    private Color toColor(String c) {
        int a = 255;
        Color clr = Color.GRAY;
        if (c.startsWith("rgb")) {
            Matcher matcher = RGBA_PATTERN.matcher(c);
            if (matcher.matches()) {
                if (matcher.groupCount() > 5) {
                    a = Math.min(255, (int)Math.round(Double.parseDouble(matcher.group(5)) * 255.0));
                }
                clr = a == 255 ? new Color(Math.min(255, Integer.parseInt(matcher.group(1))), Math.min(255, Integer.parseInt(matcher.group(2))), Math.min(255, Integer.parseInt(matcher.group(3)))) : new Color(Math.min(255, Integer.parseInt(matcher.group(1))), Math.min(255, Integer.parseInt(matcher.group(2))), Math.min(255, Integer.parseInt(matcher.group(3))), a);
            }
            return clr;
        }
        if (c.charAt(0) == '#') {
            c = c.substring(1);
        }
        if (c.length() > 7) {
            a = Integer.parseInt(c.substring(0, 2), 16);
            c = c.substring(2);
        }
        if (c.length() == 3) {
            clr = new Color(Math.min(255, Integer.parseInt(c.substring(0, 1), 16) * 17), Math.min(255, Integer.parseInt(c.substring(1, 2), 16) * 17), Math.min(255, Integer.parseInt(c.substring(2), 16) * 17));
        }
        if (c.length() == 6) {
            clr = new Color(Math.min(255, Integer.parseInt(c.substring(0, 2), 16)), Math.min(255, Integer.parseInt(c.substring(2, 4), 16)), Math.min(255, Integer.parseInt(c.substring(4), 16)), a);
        }
        return clr;
    }

    private String getCssColor(JColorSelector cs) {
        return this.getCssColor(this.toColor(cs));
    }

    private String getCssColor(String c) {
        return this.getCssColor(this.toColor(c));
    }

    private String getCssColor(Color c) {
        if (c == null) {
            return "transparent";
        }
        Double a = (double)c.getAlpha() / 255.0;
        if (a < this.FULLY_TRANSP) {
            return "transparent";
        }
        if (a < this.FULLY_OPAQUE) {
            return "rgba(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "," + (double)Math.round(a * 1000.0) / 1000.0 + ")";
        }
        return "rgba(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ",1)";
    }

    private Double getAlpha(JColorSelector cs) {
        Color c = this.toColor(cs);
        return (double)c.getAlpha() / 255.0;
    }

    private Double getAlpha(Color c) {
        return (double)c.getAlpha() / 255.0;
    }

    private Double getAlpha(String clr) {
        Color c = this.toColor(clr);
        return (double)c.getAlpha() / 255.0;
    }

    private String setAlpha(String clr, Double a) {
        Color c = this.toColor(clr);
        return "rgba(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "," + a + ")";
    }

    private Color flatColor(JColorSelector bc, JColorSelector fc) {
        return this.flatColor(this.toColor(bc), this.toColor(fc));
    }

    private Color flatColor(Color bc, Color fc) {
        Double a = (double)fc.getAlpha() / 255.0;
        if (a < this.FULLY_TRANSP) {
            return bc;
        }
        if (a > this.FULLY_OPAQUE) {
            return fc;
        }
        return new Color((int)Math.max(0L, Math.min(Math.round(a * (double)fc.getRed() + (1.0 - a) * (double)bc.getRed()), 255L)), (int)Math.max(0L, Math.min(Math.round(a * (double)fc.getGreen() + (1.0 - a) * (double)bc.getGreen()), 255L)), (int)Math.max(0L, Math.min(Math.round(a * (double)fc.getBlue() + (1.0 - a) * (double)bc.getBlue()), 255L)));
    }

    private String getMiddleColor(String c1, String c2) {
        Color c = this.getMiddleColor(this.toColor(c1), this.toColor(c2));
        return "rgba(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "," + Double.valueOf(c.getAlpha()) / 255.0 + ")";
    }

    private Color getMiddleColor(Color c1, Color c2) {
        return new Color(Math.round((c1.getRed() + c2.getRed()) / 2), Math.round((c1.getGreen() + c2.getGreen()) / 2), Math.round((c1.getBlue() + c2.getBlue()) / 2), Math.round((c1.getAlpha() + c2.getAlpha()) / 2));
    }

    private String getFlatColor(JColorSelector bc, JColorSelector fc) {
        return this.getCssColor(this.flatColor(this.toColor(bc), this.toColor(fc)));
    }

    private String getFlatColor(String bc, String fc) {
        return this.getCssColor(this.flatColor(this.toColor(bc), this.toColor(fc)));
    }

    private String getFlatColor(Color bc, Color fc) {
        return this.getCssColor(this.flatColor(bc, fc));
    }

    private Double getLuminosity(JColorSelector bg, JColorSelector fg) {
        return this.getLuminosity(this.flatColor(bg, fg));
    }

    private Double getLuminosity(JColorSelector cs) {
        return this.getLuminosity(this.toColor(cs));
    }

    private Double getLuminosity(String c) {
        return this.getLuminosity(this.toColor(c));
    }

    private Double getLuminosity(Color c) {
        return 0.0011725490196078 * (double)c.getRed() + 0.0023019607843137 * (double)c.getGreen() + 4.470588235294118E-4 * (double)c.getBlue();
    }

    private boolean isLightColor(JColorSelector cs) {
        return this.getLuminosity(cs) > 0.5;
    }

    private boolean isLightColor(String fc) {
        return this.getLuminosity(fc) > 0.5;
    }

    private boolean isLightColor(JColorSelector fc, double threshold) {
        return this.getLuminosity(fc) > threshold;
    }

    private boolean isLightColor(String fc, double threshold) {
        return this.getLuminosity(fc) > threshold;
    }

    private boolean isLightColor(JColorSelector bc, JColorSelector fc) {
        return this.isLightColor(this.toColor(bc), this.toColor(fc), (Double)0.5);
    }

    private boolean isLightColor(String bc, String fc) {
        return this.isLightColor(this.toColor(bc), this.toColor(fc), (Double)0.5);
    }

    private boolean isLightColor(JColorSelector bc, JColorSelector fc, Double threshold) {
        return this.isLightColor(this.toColor(bc), this.toColor(fc), threshold);
    }

    private boolean isLightColor(String bc, String fc, Double threshold) {
        return this.isLightColor(this.toColor(bc), this.toColor(fc), threshold);
    }

    private boolean isLightColor(Color bc, Color fc, Double threshold) {
        Double a = (double)fc.getAlpha() / 255.0;
        if (a > this.FULLY_OPAQUE) {
            return this.getLuminosity(fc) >= threshold;
        }
        return this.getLuminosity(this.flatColor(bc, fc)) >= threshold;
    }

    private String getLegibleColor(Color bc1, Color bc2, Color fc, Double f) {
        Color bc = this.flatColor(bc1, bc2);
        return this.getLegibleColor(bc, fc, f);
    }

    private String getLegibleColor(JColorSelector bc, JColorSelector fc) {
        return this.getLegibleColor(this.toColor(bc), this.toColor(fc), (Double)0.6);
    }

    private String getLegibleColor(JColorSelector bc, JColorSelector fc, Double f) {
        return this.getLegibleColor(this.toColor(bc), this.toColor(fc), f);
    }

    private String getLegibleColor(JColorSelector bc1, JColorSelector bc2, JColorSelector fc) {
        return this.getLegibleColor(this.flatColor(bc1, bc2), this.toColor(fc), (Double)0.6);
    }

    private String getLegibleColor(JColorSelector bc1, JColorSelector bc2, JColorSelector fc, Double f) {
        return this.getLegibleColor(this.flatColor(bc1, bc2), this.toColor(fc), f);
    }

    private String getLegibleColor(Color bc, Color fc, Double f) {
        int b;
        int g;
        int r;
        if (Math.abs(this.getLuminosity(bc) - this.getLuminosity(fc)) >= f) {
            return this.getCssColor(fc);
        }
        f = f * 255.0;
        if (this.getLuminosity(bc) > 0.5) {
            r = (int)Math.round(Math.max((double)fc.getRed() - f, 0.0));
            g = (int)Math.round(Math.max((double)fc.getGreen() - f, 0.0));
            b = (int)Math.round(Math.max((double)fc.getBlue() - f, 0.0));
        } else {
            r = (int)Math.round(Math.min((double)fc.getRed() + f, 255.0));
            g = (int)Math.round(Math.min((double)fc.getGreen() + f, 255.0));
            b = (int)Math.round(Math.min((double)fc.getBlue() + f, 255.0));
        }
        return this.getCssColor(new Color(r, g, b));
    }

    private void getFileToRes(String[] extensions, JTextField name, Component c) {
        String fn;
        this.fc.setFileFilter((FileFilter)new FileNameExtensionFilter(this.getText("ui.select"), extensions));
        int returnVal = this.fc.showOpenDialog(c);
        if (returnVal == 0 && !(fn = this.fc.getSelectedFile().toString()).trim().equals("")) {
            File src = new File(fn);
            File dst = new File(this.context.getPluginContext().getRootFolder().getFile(), "res");
            if (!dst.exists()) {
                dst.mkdir();
            }
            if (src.exists() && dst.exists()) {
                try {
                    IO.copyFile((File)src, (File)dst);
                    name.setText(src.getName());
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
        }
    }

    private void backupProjectFile(String ver) {
        try {
            File projectFile = this.window.projectChooser.getSelectedFile();
            IO.copyFile((File)projectFile, (File)new File(projectFile.getParentFile(), IO.baseName((File)projectFile) + "-" + (ver == null ? "old" : ver) + ".jap"));
        }
        catch (IOException ex) {
            JAlbum.logger.log(Level.FINE, "Error backing up project file: {0}", this.window.projectChooser.getSelectedFile());
        }
    }

    private static Icon icon(String basename) {
        return Icons.get(Lazaicon.class, (String)("svg/" + basename + ".svg"), (int)18);
    }

    private static Icon icon(String basename, int size) {
        return Icons.get(Lazaicon.class, (String)("svg/" + basename + ".svg"), (int)size);
    }

    private static Icon svgIcon(String basename, Dimension dim) {
        return Gui.svgIcon(basename, dim, false);
    }

    private static Icon svgIcon(String basename, Dimension dim, boolean adapt) {
        DeferredSVGIcon icon = new DeferredSVGIcon(Gui.class, "graphics/" + basename + ".svg");
        icon.setAntiAlias(true);
        icon.setAdaptColors(adapt);
        icon.setPreferredSize(dim);
        icon.setAutosize(4);
        return icon;
    }

    private Object[] getPosition() {
        return new Object[]{new Item((Object)"left top", (Object)this.getText("ui.left_top")), new Item((Object)"center top", (Object)this.getText("ui.center_top")), new Item((Object)"right top", (Object)this.getText("ui.right_top")), new Item((Object)"left center", (Object)this.getText("ui.left_middle")), new Item((Object)"center center", (Object)this.getText("ui.center_middle")), new Item((Object)"right center", (Object)this.getText("ui.right_middle")), new Item((Object)"left bottom", (Object)this.getText("ui.left_bottom")), new Item((Object)"center bottom", (Object)this.getText("ui.center_bottom")), new Item((Object)"right bottom", (Object)this.getText("ui.right_bottom"))};
    }

    private int setSelectedValue(JComboBox<Item> box, Object val) {
        int size = box.getItemCount();
        for (int i = 0; i < size; ++i) {
            Item it = box.getItemAt(i);
            if (!it.item.equals(val)) continue;
            box.setSelectedIndex(i);
            return i;
        }
        return -1;
    }

    private String getSelectedValue(Object o) {
        if (o instanceof JComboBox) {
            Object so = ((JComboBox)o).getSelectedItem();
            if (so instanceof Item) {
                return ((Item)so).value.toString();
            }
            return so == null ? null : so.toString();
        }
        return o == null ? null : o.toString();
    }

    private int getSpinnerValueAsInt(JSpinner o) {
        return (Integer)o.getValue();
    }

    private Double getSpinnerValueAsDouble(JSpinner o) {
        return (Double)o.getValue();
    }

    private Double getSelectedValueAsDouble(Object o) {
        if (o instanceof JComboBox) {
            Object so = ((JComboBox)o).getSelectedItem();
            if (so instanceof Item) {
                String s = ((Item)so).value.toString();
                return s != null && s.length() > 0 ? Double.valueOf(Double.parseDouble(s)) : null;
            }
            return null;
        }
        return o == null ? null : Double.valueOf(Double.parseDouble(o.toString()));
    }

    private Integer getSelectedValueAsInt(JComboBox o) {
        Object so = o.getSelectedItem();
        if (so instanceof Item) {
            return Integer.parseInt(((Item)so).value.toString());
        }
        return null;
    }

    private Double getThumbAspectRatio() {
        String[] cdim = this.engine.getThumbSize().split("x");
        Double w = Double.parseDouble(cdim[0]);
        Double h = Double.parseDouble(cdim[1]);
        if (w != null && h != null) {
            return w / h;
        }
        JAlbum.logger.log(Level.FINE, "Invalid thumbnail dimensions: {0} x {1}", new Object[]{w.toString(), h.toString()});
        return null;
    }

    private void allowHTMLEditing(JSmartTextArea ta) {
        try {
            ((JSmartTextArea)ta.setAllowHTMLEditing(true)).setFullHTMLEditing(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void allowSpelling(JSmartTextArea ta) {
        try {
            ta.spelling();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String majorVersion(String s) {
        int i = s.indexOf(".");
        if (i > 0) {
            return s.substring(0, i);
        }
        return s;
    }

    private int getMajorVersion(Object v) {
        if (v == null) {
            return -1;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            try {
                return Integer.valueOf(this.majorVersion((String)v));
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        if (v instanceof Double) {
            return (int)Math.floor((Double)v);
        }
        return -1;
    }

    Boolean checkBooleanProperty(AlbumObject[] sel, String pn) {
        if (sel.length > 1) {
            boolean v = (Boolean)sel[0].getProperties().get(pn, (Object)false);
            for (AlbumObject ao : sel) {
                if ((Boolean)ao.getProperties().get(pn, (Object)false) == v) continue;
                return null;
            }
            return v;
        }
        if (sel.length == 1) {
            return (Boolean)sel[0].getProperties().get(pn, (Object)false);
        }
        return null;
    }

    void createMenuItemForBooleanProperty(JMenu menu, String pn, String title) {
        this.createMenuItemForBooleanProperty(menu, this.window.albumExplorer.explorer.getSelectedAlbumObjects(), pn, title);
    }

    void createMenuItemForBooleanProperty(JMenu menu, AlbumObject[] sel, String pn, String title) {
        Boolean cv = this.checkBooleanProperty(sel, pn);
        try {
            if (cv == null) {
                JMenu subMenu = new JMenu(title);
                JMenuItem all = new JMenuItem(this.getText("ui.all"));
                all.addActionListener(ae -> {
                    for (AlbumObject ao : sel) {
                        ao.getProperties().put(pn, (Object)true);
                        ao.getProperties().save();
                    }
                });
                JMenuItem none = new JMenuItem(this.getText("ui.none"));
                none.addActionListener(ae -> {
                    for (AlbumObject ao : sel) {
                        ao.getProperties().put(pn, (Object)false);
                        ao.getProperties().save();
                    }
                });
                subMenu.add(all);
                subMenu.add(none);
                menu.add(subMenu);
            } else {
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(title, null, cv);
                menuItem.addActionListener(ae -> {
                    for (AlbumObject ao : sel) {
                        ao.getProperties().put(pn, (Object)(cv == false ? 1 : 0));
                        ao.getProperties().save();
                    }
                });
                menu.add(menuItem);
            }
        }
        catch (Throwable ex) {
            JAlbum.logger.log(Level.INFO, "Right-click menu is available only in jAlbum v32 and newer!");
        }
    }

    public Gui() {
        this(JAlbumContext.getInstance());
    }

    public Gui(JAlbumContext context) {
        super(context);
        PluginContext pc = context.getPluginContext();
        EditPanel editPanel = pc.getEditPanel();
        editPanel.addCustomTab(this.getText("ui.imageData"), (JComponent)((Object)new ImageDataUI(context, this.texts)));
        this.skinUi.setBorder(this.emptyBorder);
        ((RiverLayout)this.getLayout()).setVgap(0);
        ((RiverLayout)this.getLayout()).setHgap(0);
        this.window.setSkinUI(this.skinUi);
        this.skinReadyAt = System.currentTimeMillis();
    }

    static /* synthetic */ String access$800(Gui x0, String x1) {
        return x0.majorVersion(x1);
    }

    static /* synthetic */ Object[] access$900(Gui x0) {
        return x0.getPosition();
    }
}

