/*
 * Decompiled with CFR 0.152.
 */
package story;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.CompiledBase;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.util.Scope;

public class Zip
extends CompiledBase {
    private final ArrayList<String> statusStack = new ArrayList();

    public Zip(AlbumBean engine) {
        super(engine);
    }

    private void updateStatus(String s) {
        if (this.window != null) {
            this.statusStack.add(this.window.statusBar.getText());
            this.window.statusBar.setText(s);
        }
    }

    private void revertStatus() {
        if (this.window != null) {
            if (this.statusStack.isEmpty()) {
                this.window.statusBar.setText("");
            } else {
                this.window.statusBar.setText(this.statusStack.get(this.statusStack.size() - 1));
                this.statusStack.remove(this.statusStack.size() - 1);
            }
        }
    }

    private String urlDecode(String s) {
        if (s == null) {
            return s;
        }
        try {
            s = URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            JAlbum.logger.log(Level.WARNING, "Unsupported encoding exception \"{0}\"", s);
        }
        return s;
    }

    private boolean isEmpty(Object o) {
        return o == null || o.toString().trim().equals("");
    }

    private int zipFolder(AlbumObject folder, ZipOutputStream out, String type) throws IOException {
        byte[] buff = new byte[2048];
        boolean orig = type.equals("originals");
        boolean incl = type.equals("included") || type.equals("hires");
        File outDir = new File(this.rootOutputDirectory, folder.getPathFromRoot());
        File file = null;
        int added = 0;
        for (AlbumObject ao : folder.getChildren()) {
            Category cat;
            if (!ao.isIncluded() || (cat = ao.getCategory()) == Category.webPage || cat == Category.folder || cat == Category.webLocation) continue;
            if (orig) {
                file = ao.getFile();
            } else {
                Scope vars = ao.getVars();
                if (vars != null) {
                    String fp = incl ? "originalPath" : (cat == Category.video ? "videoPath" : (cat == Category.image ? "imagePath" : "closeupPath"));
                    String f = this.urlDecode((String)vars.get(fp));
                    JAlbum.logger.log(Level.FINER, "zipFolder: Adding {0} ({1})", new Object[]{ao.getName(), f});
                    if (!this.isEmpty(f)) {
                        file = new File(outDir, f);
                    }
                }
            }
            if (file != null && file.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    JAlbum.logger.log(Level.WARNING, "zipFolder: File could not be opened: {0}", file.toString());
                }
                if (in == null) continue;
                try {
                    int len;
                    out.putNextEntry(new ZipEntry(file.getName()));
                    while ((len = in.read(buff)) > 0) {
                        out.write(buff, 0, len);
                    }
                }
                catch (IOException e) {
                    JAlbum.logger.log(Level.WARNING, "IO Exception {0}", e);
                }
                out.closeEntry();
                in.close();
                ++added;
                continue;
            }
            if (incl) continue;
            JAlbum.logger.log(Level.WARNING, "zipFolder: File does not exists: {0}", file == null ? ao.getName() : file.toString());
        }
        return added;
    }

    private void zipImages(AlbumObject folder, String type) {
        block10: {
            String zipName = folder.getWebName() + ".zip";
            this.updateStatus("Zipping files in folder: " + folder.toString());
            try {
                int added;
                File zip = new File(this.rootOutputDirectory, folder.getPathFromRoot());
                if (!zip.exists() || (zip = new File(zip, zipName)).exists() && zip.lastModified() >= folder.getLastModified()) break block10;
                if (zip.exists() && zip.canWrite()) {
                    zip.delete();
                }
                try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(zip));){
                    added = this.zipFolder(folder, zout, type);
                    zout.flush();
                }
                if (added == 0) {
                    zip.delete();
                }
            }
            catch (IOException e) {
                JAlbum.logger.log(Level.WARNING, "IO Error:", e);
            }
        }
        this.revertStatus();
        for (AlbumObject ao : folder.getChildren()) {
            if (ao.getCategory() != Category.folder || !ao.isIncluded() || ao.isHidden()) continue;
            this.zipImages(ao, type);
        }
    }

    private int zipAll(File folder, ZipOutputStream out, String base, String zipName) throws IOException {
        byte[] buff = new byte[2048];
        int baselen = base.length() + 1;
        int added = 0;
        this.updateStatus("Zipping folder: " + folder.toString());
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                added += this.zipAll(file, out, base, zipName);
                continue;
            }
            String name = file.getName();
            if (name.equals(zipName)) continue;
            name = file.getAbsolutePath();
            if (baselen > 0) {
                name = name.substring(baselen);
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
            }
            catch (IOException e) {
                JAlbum.logger.log(Level.WARNING, "File error: {0}, {1}", new Object[]{file.getName(), e});
            }
            if (in == null) continue;
            try {
                int len;
                out.putNextEntry(new ZipEntry(name));
                while ((len = in.read(buff)) > 0) {
                    out.write(buff, 0, len);
                }
            }
            catch (IOException e) {
                JAlbum.logger.log(Level.WARNING, "IO Exception {0}", e);
            }
            out.closeEntry();
            in.close();
            ++added;
        }
        this.revertStatus();
        return added;
    }

    private void zipOutputDirectory() {
        String zipName = this.rootFolder.getWebName() + ".zip";
        try {
            int added;
            File zip = new File(this.rootOutputDirectory, zipName);
            if (zip.lastModified() >= JAlbumUtilities.deepLastModified((AlbumObject)this.rootFolder)) {
                return;
            }
            if (zip.exists() && zip.canWrite()) {
                zip.delete();
            }
            try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(zip));){
                added = this.zipAll(this.rootOutputDirectory, zout, this.rootOutputDirectory.getAbsolutePath(), zipName);
                zout.flush();
            }
            if (added == 0) {
                zip.delete();
            }
        }
        catch (IOException e) {
            JAlbum.logger.log(Level.WARNING, "IO Error:", e);
        }
    }

    public void createZip(String type) {
        if (type.equals("album")) {
            this.zipOutputDirectory();
        } else {
            this.zipImages(this.rootFolder, type);
        }
    }
}

