/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.editor;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.ToolTipSupplier;
import se.datadosen.util.IO;

public class EnglishLookupSupplier
implements ToolTipSupplier {
    private Map<String, String> englishMap;

    public EnglishLookupSupplier(File file) {
        File englishFile = new File(file.getParentFile(), "texts.properties");
        if (englishFile.exists()) {
            try {
                this.englishMap = IO.readMapFile((File)englishFile);
            }
            catch (IOException ex) {
                Logger.getLogger(EnglishLookupSupplier.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public String getToolTipText(RTextArea ta, MouseEvent e) {
        if (this.englishMap == null) {
            return null;
        }
        int offset = ta.viewToModel2D((Point2D)e.getPoint());
        try {
            int line;
            int lso;
            char lastChar;
            while ((lastChar = ta.getText((lso = ta.getLineStartOffset(line = ta.getLineOfOffset(offset))) - 2, 1).charAt(0)) == '\\') {
                offset = lso - 2;
            }
            String keyLine = ta.getText(ta.getLineStartOffset(line), ta.getLineEndOffset(line) - ta.getLineStartOffset(line));
            String[] tokens = keyLine.split("=");
            if (tokens.length > 1) {
                String key = tokens[0].trim();
                return this.englishMap.get(key);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }
}

